/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.email;

import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretLocation;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecretScanningMailer {
    private static final Logger log = LoggerFactory.getLogger(SecretScanningMailer.class);
    private static final String NOTIFICATION_EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles";
    private static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-secret-scanning";
    private static final String SOY_EMAIL_TEMPLATE_MODULE = "com.atlassian.bitbucket.server.bitbucket-secret-scanning:secret-scanning-email-templates";
    private static final String SOY_TEMPLATE = "bitbucket.internal.notification.email.secretscanning.email";
    private static final String TOKEN_EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-secret-scanning:secret-scanning-email-styles";
    private final CommitService commitService;
    private final MailService mailService;
    private final boolean mailingEnabled;
    private final int maxSecretsPerEmail;
    private final PermissionService permissionService;
    private final SecurityService securityService;
    private final SoyMailBuilder soyMailBuilder;
    private final UserService userService;

    public SecretScanningMailer(CommitService commitService, MailService mailService, boolean mailingEnabled, int maxSecretsPerEmail, PermissionService permissionService, SecurityService securityService, SoyMailBuilder soyMailBuilder, UserService userService) {
        this.commitService = commitService;
        this.mailService = mailService;
        this.mailingEnabled = mailingEnabled;
        this.maxSecretsPerEmail = maxSecretsPerEmail;
        this.permissionService = permissionService;
        this.securityService = securityService;
        this.soyMailBuilder = soyMailBuilder;
        this.userService = userService;
    }

    @EventListener
    public void onSecretsFound(SecretsDetectedEvent event) {
        if (!this.mailingEnabled) {
            log.trace("Found secrets in {}, but not sending email notifications as it has been disabled.", (Object)event.getRepository());
            return;
        }
        if (!this.mailService.isHostConfigured()) {
            log.warn("Could not send an e-mail about detected secrets because there is no mail service configured. Please configure a mail server to stop this message.");
            return;
        }
        Map<String, Commit> commits = this.getCommitMap(event);
        Repository repository = event.getRepository();
        List<SecretLocation> secrets = this.filterOutSecretsWithInvalidCommits(event, commits);
        ApplicationUser initiatingUser = this.getInitiatingUser(event);
        Map<ApplicationUser, List<SecretLocation>> secretsByRecipient = this.getSecretsByRecipient(secrets, initiatingUser, commits);
        for (Map.Entry<ApplicationUser, List<SecretLocation>> entry : secretsByRecipient.entrySet()) {
            ApplicationUser recipient = entry.getKey();
            List<SecretLocation> allSecretLocations = entry.getValue();
            for (List secretLocations : Lists.partition(allSecretLocations, (int)this.maxSecretsPerEmail)) {
                for (MailMessage mailMessage : this.buildMessage(commits, initiatingUser, recipient, repository, secretLocations)) {
                    this.mailService.submit(mailMessage);
                }
            }
        }
    }

    private static Map<String, Object> getContext(Repository repository, @Nullable ApplicationUser initiatingUser, ApplicationUser recipient, List<SecretLocation> secretLocations, Map<String, Commit> commits) {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder().put((Object)"moduleKey", (Object)NOTIFICATION_EMAIL_STYLES_MODULE).put((Object)"repository", (Object)repository).put((Object)"secrets", secretLocations.stream().map(secret -> SecretScanningMailer.mapSecretToContext(secret, commits)).collect(Collectors.toList())).put((Object)"includeCommitterColumn", (Object)SecretScanningMailer.shouldIncludeCommitterColumn(secretLocations, commits));
        if (initiatingUser != null) {
            contextBuilder.put((Object)"initiatingUser", (Object)initiatingUser);
        }
        return contextBuilder.build();
    }

    @VisibleForTesting
    static boolean isDifferentPerson(@Nullable Person person1, @Nullable Person person2) {
        if (person1 == null && person2 == null) {
            return false;
        }
        if (person1 == null || person2 == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)person2.getEmailAddress()) && !StringUtils.isBlank((CharSequence)person1.getEmailAddress())) {
            return !person2.getEmailAddress().equalsIgnoreCase(person1.getEmailAddress());
        }
        return !person1.getName().equalsIgnoreCase(person2.getName());
    }

    private static Map<String, Object> mapSecretToContext(SecretLocation secret, Map<String, Commit> commits) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"ruleName", (Object)secret.getRuleName()).put((Object)"path", (Object)secret.getPath()).put((Object)"commit", (Object)commits.get(secret.getCommitId()));
        if (secret.getLine() != null) {
            mapBuilder.put((Object)"line", (Object)secret.getLine());
        }
        return mapBuilder.build();
    }

    private static boolean shouldIncludeCommitterColumn(List<SecretLocation> secretLocations, Map<String, Commit> commits) {
        return secretLocations.stream().anyMatch(secretLocation -> {
            Commit commit = (Commit)commits.get(secretLocation.getCommitId());
            return SecretScanningMailer.isDifferentPerson(commit.getAuthor(), commit.getCommitter());
        });
    }

    private Iterable<MailMessage> buildMessage(Map<String, Commit> commits, ApplicationUser initiatingUser, ApplicationUser recipient, Repository repository, List<SecretLocation> secretLocations) {
        Map<String, Object> context = SecretScanningMailer.getContext(repository, initiatingUser, recipient, secretLocations, commits);
        return this.soyMailBuilder.build(new SoyMailMessageRequest.Builder().cssModuleKey(TOKEN_EMAIL_STYLES_MODULE).context(context).recipients(Collections.singletonList(recipient)).soyTemplateModuleKey(SOY_EMAIL_TEMPLATE_MODULE).soyTemplateName(SOY_TEMPLATE).subjectKey(this.getSubjectKey(repository)).build());
    }

    private boolean canReadRepository(ApplicationUser user, Repository repository) {
        return this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ);
    }

    private boolean canReceiveEmail(Repository repository, @Nullable ApplicationUser user) {
        return user != null && !StringUtils.isBlank((CharSequence)user.getEmailAddress()) && this.canReadRepository(user, repository);
    }

    private List<SecretLocation> filterOutSecretsWithInvalidCommits(SecretsDetectedEvent event, Map<String, Commit> commits) {
        return event.getSecretLocations().stream().filter(secret -> {
            if (!commits.containsKey(secret.getCommitId())) {
                log.debug("Commit {} with secret was not found", (Object)secret.getCommitId());
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private Map<String, Commit> getCommitMap(SecretsDetectedEvent event) {
        Set commitIds = event.getSecretLocations().stream().map(SecretLocation::getCommitId).collect(Collectors.toSet());
        BulkCommitsRequest bulkCommitsRequest = new BulkCommitsRequest.Builder().commits(event.getRepository(), commitIds).ignoreMissing(true).maxMessageLength(0).build();
        HashMap<String, Commit> commits = new HashMap<String, Commit>(commitIds.size(), 1.0f);
        this.securityService.withPermission(Permission.REPO_READ, "Secret scanning").call(() -> {
            this.commitService.streamCommits(bulkCommitsRequest, (commit, repositories) -> {
                commits.put(commit.getId(), commit);
                return true;
            });
            return null;
        });
        return commits;
    }

    @Nullable
    private ApplicationUser getInitiatingUser(SecretsDetectedEvent event) {
        return event.getInitiatingUser() == null ? null : this.getUser((Person)event.getInitiatingUser());
    }

    private Map<ApplicationUser, List<SecretLocation>> getSecretsByRecipient(List<SecretLocation> secrets, @Nullable ApplicationUser initiatingUser, Map<String, Commit> commits) {
        HashMap<ApplicationUser, List<SecretLocation>> secretsByRecipient = new HashMap<ApplicationUser, List<SecretLocation>>();
        for (SecretLocation secret : secrets) {
            ApplicationUser committer;
            ApplicationUser author;
            Commit commit = commits.get(secret.getCommitId());
            Repository repository = secret.getRepository();
            boolean hasAnyRecipients = false;
            if (this.canReceiveEmail(repository, initiatingUser)) {
                secretsByRecipient.computeIfAbsent(initiatingUser, k -> new ArrayList()).add(secret);
                hasAnyRecipients = true;
            }
            if (SecretScanningMailer.isDifferentPerson((Person)initiatingUser, commit.getAuthor()) && this.canReceiveEmail(repository, author = this.getUser(commit.getAuthor()))) {
                secretsByRecipient.computeIfAbsent(author, k -> new ArrayList()).add(secret);
                hasAnyRecipients = true;
            }
            if (SecretScanningMailer.isDifferentPerson((Person)initiatingUser, commit.getCommitter()) && SecretScanningMailer.isDifferentPerson(commit.getAuthor(), commit.getCommitter()) && this.canReceiveEmail(repository, committer = this.getUser(commit.getCommitter()))) {
                secretsByRecipient.computeIfAbsent(committer, k -> new ArrayList()).add(secret);
                hasAnyRecipients = true;
            }
            if (hasAnyRecipients) continue;
            log.debug("Secret scanning detected a secret matching the rule '{}' in {}/{} commit {}, file {}, line {} but no one involved in the commit is able to be emailed.", new Object[]{secret.getRuleName(), repository.getProject().getKey(), repository.getSlug(), commit.getId(), secret.getPath(), secret.getLine()});
        }
        return secretsByRecipient;
    }

    private I18nKey getSubjectKey(Repository repository) {
        return new I18nKey("bitbucket.secretscanning.email.subject", new Object[]{repository.getProject().getName(), repository.getName()});
    }

    @Nullable
    private ApplicationUser getUser(Person person) {
        return this.userService.findUserByNameOrEmail((String)StringUtils.firstNonBlank((CharSequence[])new String[]{person.getEmailAddress(), person.getName()}));
    }
}

