/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.event;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleCreatedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleDeletedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleUpdatedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningCommitLimitReachedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningIncompleteEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningRuleCreatedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningRuleDeletedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningRuleUpdatedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.internal.secretscanning.event.SecretScanningExemptRepoAddedEvent;
import com.atlassian.bitbucket.internal.secretscanning.event.SecretScanningExemptRepoDeletedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public class SecretScanningAuditingEventListener {
    static final String ACTION_EXEMPT_REPO_ADDED = "bitbucket.secretscanning.audit.action.exempt.repo.added";
    static final String ACTION_EXEMPT_REPO_DELETED = "bitbucket.secretscanning.audit.action.exempt.repo.deleted";
    static final String ACTION_GLOBAL_ALLOWLIST_ADDED = "bitbucket.secretscanning.audit.action.global.allowlist.added";
    static final String ACTION_GLOBAL_ALLOWLIST_DELETED = "bitbucket.secretscanning.audit.action.global.allowlist.deleted";
    static final String ACTION_GLOBAL_ALLOWLIST_UPDATED = "bitbucket.secretscanning.audit.action.global.allowlist.updated";
    static final String ACTION_GLOBAL_RULE_CREATED = "bitbucket.secretscanning.global.rule.audit.action.created";
    static final String ACTION_GLOBAL_RULE_DELETED = "bitbucket.secretscanning.global.rule.audit.action.deleted";
    static final String ACTION_GLOBAL_RULE_UPDATED = "bitbucket.secretscanning.global.rule.audit.action.updated";
    static final String ACTION_PROJECT_ALLOWLIST_ADDED = "bitbucket.secretscanning.audit.action.project.allowlist.added";
    static final String ACTION_PROJECT_ALLOWLIST_DELETED = "bitbucket.secretscanning.audit.action.project.allowlist.deleted";
    static final String ACTION_PROJECT_ALLOWLIST_UPDATED = "bitbucket.secretscanning.audit.action.project.allowlist.updated";
    static final String ACTION_PROJECT_RULE_CREATED = "bitbucket.secretscanning.project.rule.audit.action.created";
    static final String ACTION_PROJECT_RULE_DELETED = "bitbucket.secretscanning.project.rule.audit.action.deleted";
    static final String ACTION_PROJECT_RULE_UPDATED = "bitbucket.secretscanning.project.rule.audit.action.updated";
    static final String ACTION_REPOSITORY_ALLOWLIST_ADDED = "bitbucket.secretscanning.audit.action.repository.allowlist.added";
    static final String ACTION_REPOSITORY_ALLOWLIST_DELETED = "bitbucket.secretscanning.audit.action.repository.allowlist.deleted";
    static final String ACTION_REPOSITORY_ALLOWLIST_UPDATED = "bitbucket.secretscanning.audit.action.repository.allowlist.updated";
    static final String ACTION_REPOSITORY_RULE_CREATED = "bitbucket.secretscanning.repository.rule.audit.action.created";
    static final String ACTION_REPOSITORY_RULE_DELETED = "bitbucket.secretscanning.repository.rule.audit.action.deleted";
    static final String ACTION_REPOSITORY_RULE_UPDATED = "bitbucket.secretscanning.repository.rule.audit.action.updated";
    static final String ACTION_SECRET_DETECTED = "bitbucket.secretscanning.audit.action.secretdetected";
    static final String ACTION_SECRET_SCAN_COMMIT_LIMIT_REACHED = "bitbucket.secretscanning.audit.action.commitlimitreached";
    static final String ACTION_SECRET_SCAN_INCOMPLETE = "bitbucket.secretscanning.audit.action.scanincomplete";
    static final String ATTR_COMMAND_RESULT = "bitbucket.secretscanning.audit.attribute.scan.command.result";
    static final String ATTR_COMMIT_ID = "bitbucket.secretscanning.audit.attribute.commitid";
    static final String ATTR_INITIATING_USER = "bitbucket.secretscanning.audit.attribute.initiatinguser";
    static final String ATTR_LINE = "bitbucket.secretscanning.audit.attribute.line";
    static final String ATTR_PATH = "bitbucket.secretscanning.audit.attribute.path";
    static final String ATTR_RULE_ID = "bitbucket.secretscanning.audit.attribute.ruleid";
    static final String ATTR_RULE_LINE = "bitbucket.secretscanning.rule.audit.attribute.line";
    static final String ATTR_RULE_NAME = "bitbucket.secretscanning.rule.audit.attribute.name";
    static final String ATTR_RULE_PATH = "bitbucket.secretscanning.rule.audit.attribute.path";
    static final String ATTR_SCAN_FAILED = "bitbucket.secretscanning.audit.attribute.scan.failed";
    static final String ATTR_TRUNCATED = "bitbucket.secretscanning.audit.attribute.scan.truncated";
    private final AuditService auditService;

    public SecretScanningAuditingEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onSecretDetectedEvent(SecretsDetectedEvent event) {
        event.getSecretLocations().forEach(secretLocation -> {
            ImmutableList.Builder extraAttributes = ImmutableList.builder().add((Object)AuditAttribute.fromI18nKeys((String)ATTR_COMMIT_ID, (String)secretLocation.getCommitId()).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_PATH, (String)secretLocation.getPath()).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_LINE, (String)String.valueOf(secretLocation.getLine())).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_RULE_ID, (String)secretLocation.getRuleName()).build());
            if (event.getInitiatingUser() != null) {
                extraAttributes.add((Object)AuditAttribute.fromI18nKeys((String)ATTR_INITIATING_USER, (String)event.getInitiatingUser().getName()).build());
            }
            this.auditService.audit(this.getAuditEvent(ACTION_SECRET_DETECTED, this.getAffectedObjects(event.getRepository(), event.getInitiatingUser(), secretLocation.getCommitId()), (List<AuditAttribute>)extraAttributes.build()));
        });
    }

    @EventListener
    public void onSecretScanNotCompletedEvent(SecretScanningIncompleteEvent event) {
        ImmutableList.Builder extraAttributes = ImmutableList.builder().add((Object)AuditAttribute.fromI18nKeys((String)ATTR_COMMIT_ID, (String)event.getCommitId()).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_SCAN_FAILED, (String)String.valueOf(event.isFailed())).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_TRUNCATED, (String)String.valueOf(event.isTruncated())).build());
        if (event.getCommandResult() != null) {
            extraAttributes.add((Object)AuditAttribute.fromI18nKeys((String)ATTR_COMMAND_RESULT, (String)event.getCommandResult().name()).build());
        }
        if (event.getInitiatingUser() != null) {
            extraAttributes.add((Object)AuditAttribute.fromI18nKeys((String)ATTR_INITIATING_USER, (String)event.getInitiatingUser().getName()).build());
        }
        this.auditService.audit(this.getAuditEvent(ACTION_SECRET_SCAN_INCOMPLETE, this.getAffectedObjects(event.getRepository(), event.getInitiatingUser(), event.getCommitId()), (List<AuditAttribute>)extraAttributes.build()));
    }

    @EventListener
    public void onSecretScanningAllowlistAddedEvent(SecretScanningAllowlistRuleCreatedEvent event) {
        Scope scope = event.getScope();
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAuditType(scope, ACTION_GLOBAL_ALLOWLIST_ADDED, ACTION_PROJECT_ALLOWLIST_ADDED, ACTION_REPOSITORY_ALLOWLIST_ADDED)).affectedObjects(this.getAffectedObjects(scope)).extraAttributes(this.getExtraAttributes((DmzSecretScanningRule)event.getRule())).build());
    }

    @EventListener
    public void onSecretScanningAllowlistDeletedEvent(SecretScanningAllowlistRuleDeletedEvent event) {
        Scope scope = event.getScope();
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAuditType(scope, ACTION_GLOBAL_ALLOWLIST_DELETED, ACTION_PROJECT_ALLOWLIST_DELETED, ACTION_REPOSITORY_ALLOWLIST_DELETED)).affectedObjects(this.getAffectedObjects(event.getScope())).extraAttributes(this.getExtraAttributes((DmzSecretScanningRule)event.getDeletedRule())).build());
    }

    @EventListener
    public void onSecretScanningAllowlistUpdatedEvent(SecretScanningAllowlistRuleUpdatedEvent event) {
        DmzSecretScanningAllowlistRule newRule = event.getNewRule();
        DmzSecretScanningAllowlistRule previousRule = event.getPreviousRule();
        Scope scope = event.getScope();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)this.getAuditType(scope, ACTION_GLOBAL_ALLOWLIST_UPDATED, ACTION_PROJECT_ALLOWLIST_UPDATED, ACTION_REPOSITORY_ALLOWLIST_UPDATED)).affectedObjects(this.getAffectedObjects(scope));
        if (!previousRule.getName().equals(newRule.getName())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_NAME).from(previousRule.getName()).to(newRule.getName()).build());
        } else {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_NAME, (String)newRule.getName()).build());
        }
        if (!previousRule.getLineRegex().equals(newRule.getLineRegex())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_LINE).from((String)previousRule.getLineRegex().orElse(null)).to((String)newRule.getLineRegex().orElse(null)).build());
        } else {
            newRule.getLineRegex().ifPresent(lineRegex -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_LINE, (String)lineRegex).build()));
        }
        if (!previousRule.getPathRegex().equals(newRule.getPathRegex())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_PATH).from((String)previousRule.getPathRegex().orElse(null)).to((String)newRule.getPathRegex().orElse(null)).build());
        } else {
            newRule.getPathRegex().ifPresent(pathRegex -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_PATH, (String)pathRegex).build()));
        }
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onSecretScanningCommitLimitReachedEvent(SecretScanningCommitLimitReachedEvent event) {
        ImmutableList.Builder extraAttributes = ImmutableList.builder();
        if (event.getInitiatingUser() != null) {
            extraAttributes.add((Object)AuditAttribute.fromI18nKeys((String)ATTR_INITIATING_USER, (String)event.getInitiatingUser().getName()).build());
        }
        this.auditService.audit(this.getAuditEvent(ACTION_SECRET_SCAN_COMMIT_LIMIT_REACHED, AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository()), (List<AuditAttribute>)extraAttributes.build()));
    }

    @EventListener
    public void onSecretScanningExemptRepoAddedEvent(SecretScanningExemptRepoAddedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_EXEMPT_REPO_ADDED).build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository())).build());
    }

    @EventListener
    public void onSecretScanningExemptRepoDeletedEvent(SecretScanningExemptRepoDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_EXEMPT_REPO_DELETED).build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository())).build());
    }

    @EventListener
    public void onSecretScanningRuleCreated(SecretScanningRuleCreatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAuditType(event.getScope(), ACTION_GLOBAL_RULE_CREATED, ACTION_PROJECT_RULE_CREATED, ACTION_REPOSITORY_RULE_CREATED)).affectedObjects(this.getAffectedObjects(event.getScope())).extraAttributes(this.getExtraAttributes(event.getRule())).build());
    }

    @EventListener
    public void onSecretScanningRuleDeleted(SecretScanningRuleDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAuditType(event.getScope(), ACTION_GLOBAL_RULE_DELETED, ACTION_PROJECT_RULE_DELETED, ACTION_REPOSITORY_RULE_DELETED)).affectedObjects(this.getAffectedObjects(event.getScope())).extraAttributes(this.getExtraAttributes(event.getDeletedRule())).build());
    }

    @EventListener
    public void onSecretScanningRuleUpdated(SecretScanningRuleUpdatedEvent event) {
        DmzSecretScanningRule newRule = event.getNewRule();
        DmzSecretScanningRule previousRule = event.getPreviousRule();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)this.getAuditType(event.getScope(), ACTION_GLOBAL_RULE_UPDATED, ACTION_PROJECT_RULE_UPDATED, ACTION_REPOSITORY_RULE_UPDATED)).affectedObjects(this.getAffectedObjects(event.getScope()));
        if (!previousRule.getName().equals(newRule.getName())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_NAME).from(previousRule.getName()).to(newRule.getName()).build());
        } else {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_NAME, (String)newRule.getName()).build());
        }
        if (!previousRule.getLineRegex().equals(newRule.getLineRegex())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_LINE).from((String)previousRule.getLineRegex().orElse(null)).to((String)newRule.getLineRegex().orElse(null)).build());
        } else {
            newRule.getLineRegex().ifPresent(lineRegex -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_LINE, (String)lineRegex).build()));
        }
        if (!previousRule.getPathRegex().equals(newRule.getPathRegex())) {
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_RULE_PATH).from((String)previousRule.getPathRegex().orElse(null)).to((String)newRule.getPathRegex().orElse(null)).build());
        } else {
            newRule.getPathRegex().ifPresent(pathRegex -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_RULE_PATH, (String)pathRegex).build()));
        }
        this.auditService.audit(builder.build());
    }

    private List<AuditResource> getAffectedObjects(Repository repository, @Nullable ApplicationUser user, String commitId) {
        ImmutableList.Builder affectedObjects = ImmutableList.builder();
        affectedObjects.addAll((Iterable)AuditUtils.auditResourcesForProjectAndRepository((Repository)repository));
        affectedObjects.add((Object)AuditUtils.auditResourceForCommit((Repository)repository, (String)commitId));
        if (user != null) {
            affectedObjects.add((Object)AuditUtils.auditResourceForUser((ApplicationUser)user));
        }
        return affectedObjects.build();
    }

    private List<AuditResource> getAffectedObjects(Scope scope) {
        return (List)scope.accept((ScopeVisitor)new ScopeVisitor<List<AuditResource>>(this){

            public List<AuditResource> visit(@Nonnull GlobalScope scope) {
                return Collections.emptyList();
            }

            public List<AuditResource> visit(@Nonnull ProjectScope scope) {
                return Collections.singletonList(AuditUtils.auditResourceForProject((Project)scope.getProject()));
            }

            public List<AuditResource> visit(@Nonnull RepositoryScope scope) {
                return AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository());
            }
        });
    }

    private AuditEvent getAuditEvent(String action, List<AuditResource> affectedObjects, List<AuditAttribute> extraAttributes) {
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.security", (String)action).build()).affectedObjects(affectedObjects).extraAttributes(extraAttributes).build();
    }

    private AuditType getAuditType(Scope scope, final String globalKey, final String projectKey, final String repoKey) {
        return (AuditType)scope.accept((ScopeVisitor)new ScopeVisitor<AuditType>(){

            public AuditType visit(@Nonnull GlobalScope scope) {
                return AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)globalKey).build();
            }

            public AuditType visit(@Nonnull ProjectScope scope) {
                return AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)projectKey).build();
            }

            public AuditType visit(@Nonnull RepositoryScope scope) {
                return AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)repoKey).build();
            }
        });
    }

    private List<AuditAttribute> getExtraAttributes(DmzSecretScanningRule rule) {
        return this.getExtraAttributes(rule, ATTR_RULE_NAME, ATTR_RULE_LINE, ATTR_RULE_PATH);
    }

    private List<AuditAttribute> getExtraAttributes(DmzSecretScanningRule previousRule, String attrRuleNamePrev, String attrRuleLinePrev, String attrRulePathPrev) {
        ImmutableList.Builder previousRuleAttributes = ImmutableList.builder().add((Object)AuditAttribute.fromI18nKeys((String)attrRuleNamePrev, (String)previousRule.getName()).build());
        previousRule.getLineRegex().ifPresent(lineRegex -> previousRuleAttributes.add((Object)AuditAttribute.fromI18nKeys((String)attrRuleLinePrev, (String)lineRegex).build()));
        previousRule.getPathRegex().ifPresent(pathRegex -> previousRuleAttributes.add((Object)AuditAttribute.fromI18nKeys((String)attrRulePathPrev, (String)pathRegex).build()));
        return previousRuleAttributes.build();
    }
}

