/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.rules;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningAllowlistRuleSearchRequest;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningAllowlistSetRequest;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleCreatedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleDeletedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningAllowlistRuleUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningAllowlistRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.rules.SimpleSecretScanningAllowlistRule;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningAllowlistRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

@RequireFeature(value=StandardFeature.SECRET_SCANNING)
@Transactional(readOnly=true)
public class DefaultSecretScanningAllowlistRuleService
implements DmzSecretScanningAllowlistRuleService {
    private final SecretScanningAllowlistRuleDao dao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final Validator validator;

    public DefaultSecretScanningAllowlistRuleService(SecretScanningAllowlistRuleDao dao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, Validator validator) {
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.validator = validator;
    }

    @Transactional
    public DmzSecretScanningAllowlistRule create(SecretScanningAllowlistSetRequest request, Scope scope) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(scope, "scope");
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[]{Create.class});
        this.validateRequiredRegex(request.getLineRegex(), request.getPathRegex());
        this.validateIsAdminForScope(scope);
        this.validateScopeType(scope);
        InternalSecretScanningAllowlistRule newRule = (InternalSecretScanningAllowlistRule)this.dao.create(new InternalSecretScanningAllowlistRule.Builder(request.getName()).lineRegex(request.getLineRegex()).pathRegex(request.getPathRegex()).scope(scope).build());
        DmzSecretScanningAllowlistRule rule = this.transform(newRule);
        this.eventPublisher.publish((Object)new SecretScanningAllowlistRuleCreatedEvent((Object)this, rule, scope));
        return rule;
    }

    @Transactional
    public void deleteRuleById(long id, Scope scope) {
        InternalSecretScanningAllowlistRule existingRule = (InternalSecretScanningAllowlistRule)this.dao.getById(id);
        if (existingRule == null || !this.isAdminForScope(existingRule.getScope()) || existingRule.getScope().getType() != scope.getType()) {
            return;
        }
        DmzSecretScanningAllowlistRule oldRule = this.transform(existingRule);
        this.dao.deleteById(id);
        this.eventPublisher.publish((Object)new SecretScanningAllowlistRuleDeletedEvent((Object)this, oldRule, existingRule.getScope()));
    }

    public Optional<DmzSecretScanningAllowlistRule> getRuleById(long id, Scope scope) {
        Objects.requireNonNull(scope, "scope");
        return Optional.ofNullable((InternalSecretScanningAllowlistRule)this.dao.getById(id)).filter(rule -> rule.getScope().getType() == scope.getType()).filter(rule -> this.isAdminForScope(rule.getScope())).map(this::transform);
    }

    public Page<DmzSecretScanningAllowlistRule> search(PageRequest pageRequest, Scope scope, SecretScanningAllowlistRuleSearchRequest searchRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(searchRequest, "searchRequest");
        this.validateIsAdminForScope(Objects.requireNonNull(scope, "scope"));
        return this.dao.search(pageRequest, scope, searchRequest).transform(this::transform);
    }

    @Transactional
    public DmzSecretScanningAllowlistRule update(SecretScanningAllowlistSetRequest request, Scope scope) {
        Objects.requireNonNull(request, "request");
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[]{Update.class});
        InternalSecretScanningAllowlistRule existingRule = (InternalSecretScanningAllowlistRule)this.dao.getById(request.getId());
        if (existingRule == null || !this.isAdminForScope(existingRule.getScope()) || existingRule.getScope().getType() != scope.getType()) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.nosuchrule", new Object[]{request.getId()}));
        }
        DmzSecretScanningAllowlistRule oldRule = this.transform(existingRule);
        String name = (String)ObjectUtils.firstNonNull((Object[])new String[]{request.getName(), existingRule.getName()});
        String lineRegex = (String)ObjectUtils.firstNonNull((Object[])new String[]{request.getLineRegex(), existingRule.getLineRegex().orElse(null)});
        String pathRegex = (String)ObjectUtils.firstNonNull((Object[])new String[]{request.getPathRegex(), existingRule.getPathRegex().orElse(null)});
        this.validateRequiredRegex(lineRegex, pathRegex);
        InternalSecretScanningAllowlistRule.Builder toBeUpdated = existingRule.copy().name(name).lineRegex(lineRegex).pathRegex(pathRegex);
        DmzSecretScanningAllowlistRule newRule = this.transform((InternalSecretScanningAllowlistRule)this.dao.update(toBeUpdated.build()));
        this.eventPublisher.publish((Object)new SecretScanningAllowlistRuleUpdatedEvent((Object)this, newRule, oldRule, existingRule.getScope()));
        return newRule;
    }

    private boolean isAdminForScope(Scope scope) {
        return (Boolean)scope.accept((ScopeVisitor)new ScopeVisitor<Boolean>(){

            public Boolean visit(GlobalScope scope) {
                return DefaultSecretScanningAllowlistRuleService.this.permissionService.hasGlobalPermission(Permission.ADMIN);
            }

            public Boolean visit(ProjectScope scope) {
                return DefaultSecretScanningAllowlistRuleService.this.permissionService.hasProjectPermission(scope.getProject(), Permission.PROJECT_ADMIN);
            }

            public Boolean visit(RepositoryScope scope) {
                return DefaultSecretScanningAllowlistRuleService.this.permissionService.hasRepositoryPermission(scope.getRepository(), Permission.REPO_ADMIN);
            }
        });
    }

    private DmzSecretScanningAllowlistRule transform(InternalSecretScanningAllowlistRule rule) {
        return new SimpleSecretScanningAllowlistRule.Builder(rule).build();
    }

    private void validateIsAdminForScope(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(GlobalScope scope) {
                DefaultSecretScanningAllowlistRuleService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return null;
            }

            public Void visit(ProjectScope scope) {
                DefaultSecretScanningAllowlistRuleService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(RepositoryScope scope) {
                DefaultSecretScanningAllowlistRuleService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateRequiredRegex(@Nullable String lineRegex, @Nullable String pathRegex) {
        if (StringUtils.isBlank((CharSequence)lineRegex) && StringUtils.isBlank((CharSequence)pathRegex)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.regex.required", new Object[0]));
        }
    }

    private void validateScopeType(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(GlobalScope scope) {
                throw new ArgumentValidationException(DefaultSecretScanningAllowlistRuleService.this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.scope.allowlist.global.nocreate", new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultSecretScanningAllowlistRuleService.this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.scope.project.personal.nocreate", new Object[0]));
                }
                return null;
            }
        });
    }
}

