/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.rules;

import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningRuleMatcher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class SecretScanningConfiguration {
    private final List<SecretScanningRuleMatcher> allowlistMatchers;
    private final List<SecretScanningRuleMatcher> allowlistPathOnlyMatchers;
    private final List<SecretScanningRuleMatcher> matchers;
    private final List<SecretScanningRuleMatcher> pathOnlyMatchers;

    private SecretScanningConfiguration(Builder builder) {
        this.allowlistMatchers = builder.allowlistMatchers.build();
        this.allowlistPathOnlyMatchers = builder.allowlistPathOnlyMatchers.build();
        this.matchers = builder.matchers.build();
        this.pathOnlyMatchers = builder.pathOnlyMatchers.build();
    }

    public List<SecretScanningRuleMatcher> getAllowlistMatchers() {
        return this.allowlistMatchers;
    }

    public List<SecretScanningRuleMatcher> getAllowlistPathOnlyMatchers() {
        return this.allowlistPathOnlyMatchers;
    }

    public List<SecretScanningRuleMatcher> getMatchers() {
        return this.matchers;
    }

    public List<SecretScanningRuleMatcher> getPathOnlyMatchers() {
        return this.pathOnlyMatchers;
    }

    public static class Builder {
        private final ImmutableList.Builder<SecretScanningRuleMatcher> allowlistMatchers = ImmutableList.builder();
        private final ImmutableList.Builder<SecretScanningRuleMatcher> allowlistPathOnlyMatchers = ImmutableList.builder();
        private final ImmutableList.Builder<SecretScanningRuleMatcher> matchers = ImmutableList.builder();
        private final ImmutableList.Builder<SecretScanningRuleMatcher> pathOnlyMatchers = ImmutableList.builder();

        public SecretScanningConfiguration build() {
            return new SecretScanningConfiguration(this);
        }

        public Builder allowlistMatcher(SecretScanningRuleMatcher allowlistMatcher) {
            Objects.requireNonNull(allowlistMatcher, "allowlistMatcher");
            this.allowlistMatchers.add((Object)allowlistMatcher);
            return this;
        }

        public Builder allowlistPathOnlyMatcher(SecretScanningRuleMatcher allowlistPathOnlyMatcher) {
            Objects.requireNonNull(allowlistPathOnlyMatcher, "allowlistPathOnlyMatcher");
            this.allowlistPathOnlyMatchers.add((Object)allowlistPathOnlyMatcher);
            return this;
        }

        public Builder matcher(SecretScanningRuleMatcher matcher) {
            Objects.requireNonNull(matcher, "matcher");
            this.matchers.add((Object)matcher);
            return this;
        }

        public Builder pathOnlyMatcher(SecretScanningRuleMatcher pathOnlyMatcher) {
            Objects.requireNonNull(pathOnlyMatcher, "pathOnlyMatcher");
            this.pathOnlyMatchers.add((Object)pathOnlyMatcher);
            return this;
        }
    }
}

