/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.rules;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningAllowlistRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfiguration;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningRuleMatcher;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningAllowlistRule;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningRule;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.transaction.annotation.Transactional;

public class SecretScanningConfigurationProvider {
    private final SecretScanningRuleDao dao;
    private final SecretScanningAllowlistRuleDao allowlistDao;

    public SecretScanningConfigurationProvider(SecretScanningAllowlistRuleDao allowlistDao, SecretScanningRuleDao dao) {
        this.allowlistDao = allowlistDao;
        this.dao = dao;
    }

    @Transactional
    public SecretScanningConfiguration getConfiguration(Scope scope) {
        Objects.requireNonNull(scope, "scope");
        final SecretScanningConfiguration.Builder configBuilder = new SecretScanningConfiguration.Builder();
        return (SecretScanningConfiguration)scope.accept((ScopeVisitor)new ScopeVisitor<SecretScanningConfiguration>(){

            public SecretScanningConfiguration visit(@Nonnull GlobalScope scope) {
                SecretScanningConfigurationProvider.this.populateRuleMatchers((Scope)scope, configBuilder);
                return configBuilder.build();
            }

            public SecretScanningConfiguration visit(@Nonnull ProjectScope scope) {
                SecretScanningConfigurationProvider.this.populateRuleMatchers((Scope)scope, configBuilder);
                SecretScanningConfigurationProvider.this.populateAllowlistRuleMatchers((Scope)scope, configBuilder);
                return configBuilder.build();
            }

            public SecretScanningConfiguration visit(@Nonnull RepositoryScope scope) {
                SecretScanningConfigurationProvider.this.populateRuleMatchers((Scope)scope, configBuilder);
                SecretScanningConfigurationProvider.this.populateAllowlistRuleMatchers((Scope)scope, configBuilder);
                return configBuilder.build();
            }
        });
    }

    private void populateAllowlistRuleMatchers(Scope scope, SecretScanningConfiguration.Builder configBuilder) {
        for (InternalSecretScanningAllowlistRule internalRule : this.allowlistDao.getAll(scope, true)) {
            SecretScanningRuleMatcher allowMatcher = new SecretScanningRuleMatcher((DmzSecretScanningRule)internalRule);
            if (allowMatcher.getLinePattern() == null) {
                configBuilder.allowlistPathOnlyMatcher(allowMatcher);
                continue;
            }
            configBuilder.allowlistMatcher(allowMatcher);
        }
    }

    private void populateRuleMatchers(Scope scope, SecretScanningConfiguration.Builder configBuilder) {
        for (InternalSecretScanningRule internalRule : this.dao.getAll(scope, true)) {
            SecretScanningRuleMatcher matcher = new SecretScanningRuleMatcher((DmzSecretScanningRule)internalRule);
            if (matcher.getLinePattern() == null) {
                configBuilder.pathOnlyMatcher(matcher);
                continue;
            }
            configBuilder.matcher(matcher);
        }
    }
}

