/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.rules;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.google.re2j.Pattern;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SecretScanningRuleMatcher {
    private final Pattern linePattern;
    private final String name;
    private final Pattern pathPattern;

    public SecretScanningRuleMatcher(DmzSecretScanningRule rule) {
        this(Objects.requireNonNull(rule, "rule").getName(), rule.getLineRegex().orElse(null), rule.getPathRegex().orElse(null));
    }

    SecretScanningRuleMatcher(String ruleName, @Nullable String lineRegex, @Nullable String pathRegex) {
        this.linePattern = lineRegex == null ? null : Pattern.compile((String)lineRegex);
        this.name = Objects.requireNonNull(ruleName, "ruleName");
        this.pathPattern = pathRegex == null ? null : Pattern.compile((String)pathRegex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SecretScanningRuleMatcher) {
            SecretScanningRuleMatcher that = (SecretScanningRuleMatcher)o;
            return Objects.equals(this.linePattern, that.linePattern) && Objects.equals(this.name, that.name) && Objects.equals(this.pathPattern, that.pathPattern);
        }
        return false;
    }

    @Nullable
    public Pattern getLinePattern() {
        return this.linePattern;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Pattern getPathPattern() {
        return this.pathPattern;
    }

    public int hashCode() {
        return Objects.hash(this.linePattern, this.name, this.pathPattern);
    }

    public boolean matches(CharSequence path) {
        Objects.requireNonNull(path, "path");
        return this.linePattern == null && this.matchesPath(path);
    }

    public boolean matches(CharSequence line, CharSequence path) {
        Objects.requireNonNull(line, "line");
        Objects.requireNonNull(path, "path");
        return this.matchesPath(path) && this.matchesLine(line);
    }

    private boolean matchesPath(CharSequence path) {
        return this.pathPattern == null || this.pathPattern.matcher(path).matches();
    }

    private boolean matchesLine(CharSequence line) {
        return this.linePattern == null || this.linePattern.matcher(line).find();
    }
}

