/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.rules;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningRule;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SimpleSecretScanningRule
implements DmzSecretScanningRule {
    private final long id;
    private final String lineRegex;
    private final String name;
    private final String pathRegex;
    private final Scope scope;

    private SimpleSecretScanningRule(Builder builder) {
        this.id = builder.id;
        this.lineRegex = builder.lineRegex;
        this.name = builder.name;
        this.pathRegex = builder.pathRegex;
        this.scope = builder.scope;
    }

    public long getId() {
        return this.id;
    }

    public Optional<String> getLineRegex() {
        return Optional.ofNullable(this.lineRegex);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getPathRegex() {
        return Optional.ofNullable(this.pathRegex);
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final String name;
        private final Scope scope;
        private String lineRegex;
        private String pathRegex;

        public Builder(String name) {
            this.name = Builder.requireNonBlank((String)name, (String)"name");
            this.id = 0L;
            this.scope = Scopes.global();
        }

        public Builder(InternalSecretScanningRule toBuild) {
            this.name = toBuild.getName();
            this.id = toBuild.getId();
            this.lineRegex = toBuild.getLineRegex().orElse(null);
            this.pathRegex = toBuild.getPathRegex().orElse(null);
            this.scope = toBuild.getScope();
        }

        public SimpleSecretScanningRule build() {
            if (this.lineRegex == null && this.pathRegex == null) {
                throw new IllegalArgumentException("A regex or path must be provided.");
            }
            return new SimpleSecretScanningRule(this);
        }

        public Builder lineRegex(@Nullable String value) {
            this.lineRegex = StringUtils.stripToNull((String)value);
            return this;
        }

        public Builder pathRegex(@Nullable String value) {
            this.pathRegex = StringUtils.stripToNull((String)value);
            return this;
        }
    }
}

