/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.scan;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretScanResult;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfiguration;
import com.atlassian.bitbucket.internal.secretscanning.scan.CommitSecretScanner;
import com.atlassian.bitbucket.internal.secretscanning.scan.SecretScanningDiffContentCallback;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.concurrent.ConfigurableThreadFactory;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultCommitSecretScanner
implements CommitSecretScanner {
    private final CommitService commitService;
    private final SecurityService securityService;
    private final long timeoutMillis;
    private final ScheduledThreadPoolExecutor timeoutTaskRunner;

    public DefaultCommitSecretScanner(CommitService commitService, SecurityService securityService, long timeoutMillis) {
        this.commitService = commitService;
        this.securityService = securityService;
        this.timeoutMillis = timeoutMillis;
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory();
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix("secret-scanning-timer-thread-");
        this.timeoutTaskRunner = new ScheduledThreadPoolExecutor(2, (ThreadFactory)threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretScanResult scanCommit(Repository repository, String commitId, SecretScanningConfiguration configuration) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(configuration, "configuration");
        SecretScanResult.Builder scanResultBuilder = new SecretScanResult.Builder(commitId, repository);
        SecretScanningDiffContentCallback callback = new SecretScanningDiffContentCallback(configuration, commitId, repository, scanResultBuilder);
        ScheduledFuture<?> timeoutTimer = this.timeoutTaskRunner.schedule(callback::interrupt, this.timeoutMillis, TimeUnit.MILLISECONDS);
        try {
            DiffRequest diffRequest = new DiffRequest.Builder(repository, commitId).withComments(false).contextLines(0).whitespace(DiffWhitespace.IGNORE_ALL).build();
            this.securityService.withPermission(Permission.REPO_READ, "Secret scanning").call(() -> {
                this.commitService.streamDiff(diffRequest, (DiffContentCallback)callback);
                return null;
            });
            SecretScanResult secretScanResult = scanResultBuilder.build();
            return secretScanResult;
        }
        finally {
            timeoutTimer.cancel(false);
        }
    }
}

