/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.scan;

import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretLocation;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretScanResult;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfiguration;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningRuleMatcher;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretScanningDiffContentCallback
extends AbstractDiffContentCallback {
    private static final Logger log = LoggerFactory.getLogger(SecretScanningDiffContentCallback.class);
    private final SecretScanResult.Builder scanResultBuilder;
    private final String commitId;
    private final Repository repository;
    private final List<SecretScanningRuleMatcher> matchers;
    private final List<SecretScanningRuleMatcher> pathOnlyMatchers;
    private final List<SecretScanningRuleMatcher> allowlistMatchers;
    private final List<SecretScanningRuleMatcher> allowlistPathOnlyMatchers;
    private int currentDestinationLine;
    private DiffSegmentType currentDiffSegmentType;
    private Path currentPath;
    private volatile Thread currentThread;

    public SecretScanningDiffContentCallback(SecretScanningConfiguration secretScanningConfiguration, String commitId, Repository repository, SecretScanResult.Builder scanResultBuilder) {
        this.commitId = Objects.requireNonNull(commitId, "commit");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.scanResultBuilder = Objects.requireNonNull(scanResultBuilder, "scanResultBuilder");
        Objects.requireNonNull(secretScanningConfiguration, "secretScanningRules");
        this.matchers = secretScanningConfiguration.getMatchers();
        this.pathOnlyMatchers = secretScanningConfiguration.getPathOnlyMatchers();
        this.allowlistMatchers = secretScanningConfiguration.getAllowlistMatchers();
        this.allowlistPathOnlyMatchers = secretScanningConfiguration.getAllowlistPathOnlyMatchers();
    }

    public void interrupt() {
        this.scanResultBuilder.truncated(true);
        if (this.currentThread != null) {
            this.currentThread.interrupt();
        }
    }

    public void onBinary(@Nullable Path src, @Nullable Path dst) {
        this.onNewFile(src, dst);
    }

    public void onDiffEnd(boolean truncated) {
        this.currentPath = null;
    }

    public void onDiffStart(@Nullable Path src, @Nullable Path dst) {
        this.onNewFile(src, dst);
    }

    public void onEnd(@Nonnull DiffSummary summary) {
        if (summary.isTruncated()) {
            this.scanResultBuilder.truncated(true);
        }
        this.scanResultBuilder.commandResult(summary.getResult());
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, @Nullable String context) {
        this.currentDestinationLine = dstLine;
    }

    public void onSegmentEnd(boolean truncated) {
        this.currentDiffSegmentType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSegmentLine(@Nonnull String line, @Nullable ConflictMarker marker, boolean truncated) {
        if (this.currentPath == null || this.currentDiffSegmentType != DiffSegmentType.ADDED) {
            return;
        }
        try {
            this.currentThread = Thread.currentThread();
            if (truncated) {
                this.scanResultBuilder.truncated(true);
            }
            for (SecretScanningRuleMatcher matcher : this.matchers) {
                try {
                    String path = this.currentPath.toString();
                    if (!matcher.matches(line, path)) continue;
                    if (this.allowlistMatchers.stream().anyMatch(allowlist -> allowlist.matches(line, path))) {
                        log.debug("Allowlist rule matched, found secret is not reported on file {} in commit {}", (Object)path, (Object)this.commitId);
                        break;
                    }
                    this.scanResultBuilder.addSecretLocation(new SecretLocation(this.repository, this.commitId, Integer.valueOf(this.currentDestinationLine), path, matcher.getName()));
                }
                catch (RuntimeException e) {
                    log.info("Secret scanning failed for rule {}, on commit {}", new Object[]{matcher.getName(), this.commitId, e});
                    this.scanResultBuilder.scanFailed();
                }
            }
            ++this.currentDestinationLine;
        }
        finally {
            this.currentThread = null;
            Thread.interrupted();
        }
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) {
        this.currentDiffSegmentType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewFile(@Nullable Path src, @Nullable Path dst) {
        this.currentPath = dst;
        if (dst == null || Objects.equals(src, dst)) {
            return;
        }
        try {
            this.currentThread = Thread.currentThread();
            for (SecretScanningRuleMatcher matcher : this.pathOnlyMatchers) {
                try {
                    String path = this.currentPath.toString();
                    if (!matcher.matches(path)) continue;
                    if (this.allowlistPathOnlyMatchers.stream().anyMatch(allowlist -> allowlist.matches(path))) {
                        log.debug("Allowlist rule matched, found secret is not reported on file {} in commit {}", (Object)path, (Object)this.commitId);
                        break;
                    }
                    this.scanResultBuilder.addSecretLocation(new SecretLocation(this.repository, this.commitId, this.currentPath.toString(), matcher.getName()));
                }
                catch (RuntimeException e) {
                    log.info("Secret scanning failed for rule {}, on commit {}", new Object[]{matcher.getName(), this.commitId, e});
                    this.scanResultBuilder.scanFailed();
                }
            }
        }
        finally {
            this.currentThread = null;
            Thread.interrupted();
        }
    }
}

