/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.support;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningAllowlistRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.support.SupportDataRulesEnricher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.List;
import java.util.Objects;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultSupportDataRulesEnricher
implements SupportDataRulesEnricher {
    private final SecretScanningAllowlistRuleDao allowlistRuleDao;
    private final SecretScanningRuleDao ruleDao;

    public DefaultSupportDataRulesEnricher(SecretScanningAllowlistRuleDao allowlistRuleDao, SecretScanningRuleDao ruleDao) {
        this.allowlistRuleDao = allowlistRuleDao;
        this.ruleDao = ruleDao;
    }

    @Override
    public void enrichWithAllowlistRules(SupportDataBuilder builder, String category, Scope scope) {
        Objects.requireNonNull(builder, "builder");
        Objects.requireNonNull(category, "scope");
        Objects.requireNonNull(scope, "scope");
        this.addRules(builder, category, this.allowlistRuleDao.getAll(scope, false));
    }

    @Override
    public void enrichWithRules(SupportDataBuilder builder, String category, Scope scope) {
        Objects.requireNonNull(builder, "builder");
        Objects.requireNonNull(category, "scope");
        Objects.requireNonNull(scope, "scope");
        this.addRules(builder, category, this.ruleDao.getAll(scope, false));
    }

    private void addRules(SupportDataBuilder builder, String category, List<? extends DmzSecretScanningRule> rules) {
        if (rules.isEmpty()) {
            return;
        }
        SupportDataBuilder rulesBuilder = builder.addCategory(category);
        rules.forEach(rule -> rulesBuilder.addCategory("bitbucket.atst.secretscanning.rule").addValue("bitbucket.atst.secretscanning.rule.name", rule.getName()).addValue("bitbucket.atst.secretscanning.rule.line.pattern", rule.getLineRegex().orElse("")).addValue("bitbucket.atst.secretscanning.rule.path.pattern", rule.getPathRegex().orElse("")));
    }
}

