/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.support;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.internal.secretscanning.support.SupportDataRulesEnricher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class GlobalSecretScanningSupportData
extends RootLevelSupportDataAppender {
    private final DmzSecretScanningExemptRepositoryService exemptRepositoryService;
    private final FeatureManager featureManager;
    private final SupportDataRulesEnricher supportDataRulesEnricher;

    public GlobalSecretScanningSupportData(DmzSecretScanningExemptRepositoryService exemptRepositoryService, FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
        this.exemptRepositoryService = exemptRepositoryService;
        this.featureManager = featureManager;
        this.supportDataRulesEnricher = supportDataRulesEnricher;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder secretScanningBuilder = supportDataBuilder.addCategory("bitbucket.atst.secretscanning");
        if (!this.featureManager.isEnabled((Feature)StandardFeature.SECRET_SCANNING)) {
            secretScanningBuilder.addValue("bitbucket.atst.secretscanning.enabled", "false");
            return;
        }
        secretScanningBuilder.addValue("bitbucket.atst.secretscanning.enabled", "true");
        secretScanningBuilder.addValue("bitbucket.atst.secretscanning.personal-repositories.exempt", Boolean.toString(this.exemptRepositoryService.isPersonalReposExempt()));
        this.supportDataRulesEnricher.enrichWithRules(secretScanningBuilder, "bitbucket.atst.secretscanning.global.rules", (Scope)Scopes.global());
    }
}

