/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.support;

import com.atlassian.bitbucket.internal.secretscanning.support.SupportDataRulesEnricher;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class ProjectSecretScanningSupportData
implements SupportDataAppender<Project> {
    private final FeatureManager featureManager;
    private final SupportDataRulesEnricher supportDataRulesEnricher;

    public ProjectSecretScanningSupportData(FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
        this.featureManager = featureManager;
        this.supportDataRulesEnricher = supportDataRulesEnricher;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Project project) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.SECRET_SCANNING)) {
            SupportDataBuilder secretScanningBuilder = supportDataBuilder.addCategory("bitbucket.atst.secretscanning");
            ProjectScope projectScope = Scopes.project((Project)project);
            this.supportDataRulesEnricher.enrichWithRules(secretScanningBuilder, "bitbucket.atst.secretscanning.project.rules", (Scope)projectScope);
            this.supportDataRulesEnricher.enrichWithAllowlistRules(secretScanningBuilder, "bitbucket.atst.secretscanning.project.allowlist-rules", (Scope)projectScope);
        }
    }
}

