/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.support;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.internal.secretscanning.support.SupportDataRulesEnricher;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class RepositorySecretScanningSupportData
implements SupportDataAppender<Repository> {
    private final DmzSecretScanningExemptRepositoryService exemptRepositoryService;
    private final FeatureManager featureManager;
    private final SupportDataRulesEnricher supportDataRulesEnricher;

    public RepositorySecretScanningSupportData(DmzSecretScanningExemptRepositoryService exemptRepositoryService, FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
        this.exemptRepositoryService = exemptRepositoryService;
        this.featureManager = featureManager;
        this.supportDataRulesEnricher = supportDataRulesEnricher;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Repository repository) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.SECRET_SCANNING)) {
            SupportDataBuilder secretScanningBuilder = supportDataBuilder.addCategory("bitbucket.atst.secretscanning");
            secretScanningBuilder.addValue("bitbucket.atst.secretscanning.repository.exempt", Boolean.toString(this.exemptRepositoryService.isExempt(repository)));
            RepositoryScope repositoryScope = Scopes.repository((Repository)repository);
            this.supportDataRulesEnricher.enrichWithRules(secretScanningBuilder, "bitbucket.atst.secretscanning.repository.rules", (Scope)repositoryScope);
            this.supportDataRulesEnricher.enrichWithAllowlistRules(secretScanningBuilder, "bitbucket.atst.secretscanning.repository.allowlist-rules", (Scope)repositoryScope);
        }
    }
}

