/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.upgrade;

import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component(value="movePrivateRepoSettingToDBUpgradeTask")
public class MovePrivateRepoSettingToDBUpgradeTask
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MovePrivateRepoSettingToDBUpgradeTask.class);
    private final boolean isEnabled;
    private final ApplicationPropertyDao propertyDao;

    public MovePrivateRepoSettingToDBUpgradeTask(String fromPropertiesFile, ApplicationPropertyDao propertyDao) {
        this.isEnabled = Boolean.parseBoolean(fromPropertiesFile);
        this.propertyDao = propertyDao;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertyDao.getById(ApplicationProperty.Key.SECRET_SCAN_ON_PRIVATE_REPOSITORIES) == null) {
            log.debug("Migrating secret scanning setting for private repositories to database");
            this.propertyDao.create(new ApplicationProperty(ApplicationProperty.Key.SECRET_SCAN_ON_PRIVATE_REPOSITORIES, Boolean.toString(this.isEnabled)));
        } else {
            log.debug("Not doing migration as value already exists in database");
        }
    }
}

