/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.validation;

import com.atlassian.bitbucket.dmz.secretscanning.validation.Re2ValidationService;
import com.atlassian.bitbucket.internal.secretscanning.validation.Re2jI18nMessageHelper;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultRe2ValidationService
implements Re2ValidationService {
    public boolean isValid(@Nullable String regex, ConstraintValidatorContext context) {
        Objects.requireNonNull(context, "context");
        if (StringUtils.isBlank((CharSequence)regex)) {
            return true;
        }
        try {
            Pattern.compile((String)regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(Re2jI18nMessageHelper.convertToI18nKey(e.getDescription())).addConstraintViolation();
            return false;
        }
    }
}

