/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secretscanning;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.validation.Re2ValidationService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.secretscanning.DefaultSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.internal.secretscanning.DefaultSecretScanningService;
import com.atlassian.bitbucket.internal.secretscanning.async.AsyncSecretScanningService;
import com.atlassian.bitbucket.internal.secretscanning.async.SecretScanningProcessor;
import com.atlassian.bitbucket.internal.secretscanning.dao.HibernateSecretScanningAllowlistRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.HibernateSecretScanningExemptRepositoryDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.HibernateSecretScanningRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningAllowlistRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningExemptRepositoryDao;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningRuleDao;
import com.atlassian.bitbucket.internal.secretscanning.email.SecretScanningMailer;
import com.atlassian.bitbucket.internal.secretscanning.event.SecretScanningAuditingEventListener;
import com.atlassian.bitbucket.internal.secretscanning.rules.DefaultSecretScanningAllowlistRuleService;
import com.atlassian.bitbucket.internal.secretscanning.rules.DefaultSecretScanningRuleService;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfigurationProvider;
import com.atlassian.bitbucket.internal.secretscanning.scan.CommitSecretScanner;
import com.atlassian.bitbucket.internal.secretscanning.scan.DefaultCommitSecretScanner;
import com.atlassian.bitbucket.internal.secretscanning.support.DefaultSupportDataRulesEnricher;
import com.atlassian.bitbucket.internal.secretscanning.support.GlobalSecretScanningSupportData;
import com.atlassian.bitbucket.internal.secretscanning.support.ProjectSecretScanningSupportData;
import com.atlassian.bitbucket.internal.secretscanning.support.RepositorySecretScanningSupportData;
import com.atlassian.bitbucket.internal.secretscanning.support.SupportDataRulesEnricher;
import com.atlassian.bitbucket.internal.secretscanning.upgrade.MovePrivateRepoSettingToDBUpgradeTask;
import com.atlassian.bitbucket.internal.secretscanning.validation.DefaultRe2ValidationService;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import jakarta.validation.Validator;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class SecretScanningWiring {
    private static final Logger log = LoggerFactory.getLogger(SecretScanningWiring.class);
    private static final int EMAIL_MAX_SECRETS_DEFAULT = 100;
    private static final int SCAN_TIMEOUT_DEFAULT_MILLIS = 1000;

    @Bean
    SecretScanningExemptRepositoryDao exemptRepositoryDao(SessionFactory sessionFactory) {
        return new HibernateSecretScanningExemptRepositoryDao(sessionFactory);
    }

    @Bean
    SecretScanningAllowlistRuleDao allowlistDao(SessionFactory sessionFactory) {
        return new HibernateSecretScanningAllowlistRuleDao(sessionFactory);
    }

    @Bean
    SecretScanningRuleDao ruleDao(SessionFactory sessionFactory) {
        return new HibernateSecretScanningRuleDao(sessionFactory);
    }

    @Bean
    @AvailableToPlugins(value=DmzSecretScanningAllowlistRuleService.class)
    DmzSecretScanningAllowlistRuleService secretScanningAllowlistService(SecretScanningAllowlistRuleDao dao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, Validator validator) {
        return new DefaultSecretScanningAllowlistRuleService(dao, eventPublisher, i18nService, permissionService, permissionValidationService, validator);
    }

    @Bean
    @AvailableToPlugins(value=DmzSecretScanningExemptRepositoryService.class)
    DmzSecretScanningExemptRepositoryService secretScanningExemptRepositoryService(EventPublisher eventPublisher, SecretScanningExemptRepositoryDao exemptRepositoryDao, I18nService i18nService, PermissionValidationService permissionValidationService, InternalApplicationPropertiesService propertiesService) {
        return new DefaultSecretScanningExemptRepositoryService(eventPublisher, exemptRepositoryDao, i18nService, permissionValidationService, propertiesService);
    }

    @Bean
    @AvailableToPlugins(value=DmzSecretScanningRuleService.class)
    DmzSecretScanningRuleService secretScanningRuleService(SecretScanningRuleDao dao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, Validator validator) {
        return new DefaultSecretScanningRuleService(dao, eventPublisher, i18nService, permissionService, permissionValidationService, validator);
    }

    @Configuration
    @DefaultApplicationMode
    public static class ApplicationModeWiring {
        @Bean
        @DependsOn(value={"secretScanningProcessor"})
        AsyncSecretScanningService asyncSecretScanningService(ApplicationPropertiesService propertiesService, ConcurrencyService concurrencyService, @Value(value="${secretscanning.max.threads}") String maxConcurrencyString, SecretScanningProcessor secretScanningProcessor, TopicService topicService) {
            int maxConcurrency = ExpressionUtils.parseExpressionAsInt((String)maxConcurrencyString).orElse(Runtime.getRuntime().availableProcessors());
            return new AsyncSecretScanningService(propertiesService, concurrencyService, maxConcurrency, secretScanningProcessor, topicService);
        }

        @Bean
        CommitSecretScanner commitScanner(CommitService commitService, SecurityService securityService, @Value(value="${secretscanning.scan.timeout}") String timeoutMillisString) {
            long timeoutMillis = ExpressionUtils.parseExpressionAsLong((String)timeoutMillisString).orElse(1000L);
            return new DefaultCommitSecretScanner(commitService, securityService, timeoutMillis);
        }

        @Bean
        GlobalSecretScanningSupportData globalSecretScanningSupportData(DmzSecretScanningExemptRepositoryService exemptRepositoryService, FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
            return new GlobalSecretScanningSupportData(exemptRepositoryService, featureManager, supportDataRulesEnricher);
        }

        @Bean
        MovePrivateRepoSettingToDBUpgradeTask movePrivateRepoSettingToDBUpgradeTask(@Value(value="${secretscanning.scan.personal.repositories:true}") String fromPropertiesFile, ApplicationPropertyDao propertyDao) {
            return new MovePrivateRepoSettingToDBUpgradeTask(fromPropertiesFile, propertyDao);
        }

        @Bean
        ProjectSecretScanningSupportData projectSecretScanningSupportData(FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
            return new ProjectSecretScanningSupportData(featureManager, supportDataRulesEnricher);
        }

        @AvailableToPlugins(value=Re2ValidationService.class)
        @Bean
        Re2ValidationService re2jValidationService() {
            return new DefaultRe2ValidationService();
        }

        @Bean
        RepositorySecretScanningSupportData repositorySecretScanningSupportData(DmzSecretScanningExemptRepositoryService exemptRepositoryService, FeatureManager featureManager, SupportDataRulesEnricher supportDataRulesEnricher) {
            return new RepositorySecretScanningSupportData(exemptRepositoryService, featureManager, supportDataRulesEnricher);
        }

        @Bean
        SecretScanningAuditingEventListener secretScanningEventListener(AuditService auditService) {
            return new SecretScanningAuditingEventListener(auditService);
        }

        @Bean
        SecretScanningMailer secretScanningMailer(CommitService commitService, MailService mailService, @Value(value="${secretscanning.email.enabled:true}") String mailingEnabledString, @Value(value="${secretscanning.email.maxsecrets}") String maxSecretsString, PermissionService permissionService, SecurityService securityService, SoyMailBuilder soyMailBuilder, UserService userService) {
            boolean mailingEnabled = Boolean.parseBoolean(mailingEnabledString);
            int maxSecrets = ExpressionUtils.parseExpressionAsInt((String)maxSecretsString).orElse(-1);
            if (maxSecrets <= 0) {
                log.warn("Invalid value for 'secretscanning.email.maxsecrets': {} is not a positive integer. Using default value of {} instead.", (Object)maxSecretsString, (Object)100);
                maxSecrets = 100;
            }
            return new SecretScanningMailer(commitService, mailService, mailingEnabled, maxSecrets, permissionService, securityService, soyMailBuilder, userService);
        }

        @Bean
        SecretScanningConfigurationProvider secretScanningMatcherProvider(SecretScanningAllowlistRuleDao allowlistDao, SecretScanningRuleDao dao) {
            return new SecretScanningConfigurationProvider(allowlistDao, dao);
        }

        @Bean(name={"secretScanningProcessor"})
        SecretScanningProcessor secretScanningProcessor(RepositoryService repositoryService, CommitSecretScanner commitSecretScanner, EventPublisher eventPublisher, SecretScanningConfigurationProvider secretScanningConfigurationProvider, SecurityService securityService, TopicService topicService) {
            return new SecretScanningProcessor(repositoryService, new DefaultSecretScanningService(commitSecretScanner, eventPublisher, secretScanningConfigurationProvider, topicService), securityService);
        }

        @Bean
        SupportDataRulesEnricher supportInfoRulesEnricher(SecretScanningAllowlistRuleDao allowlistRuleDao, SecretScanningRuleDao ruleDao) {
            return new DefaultSupportDataRulesEnricher(allowlistRuleDao, ruleDao);
        }
    }
}

