/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.markup.renderer;

import com.atlassian.bitbucket.dmz.markup.renderer.MarkupRendererComponent;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.List;

public class MarkupRendererComponentModuleDescriptor
extends AbstractModuleDescriptor<MarkupRendererComponent>
implements Comparable<MarkupRendererComponentModuleDescriptor> {
    public static final String XML_ELEMENT_NAME = "markup-renderer-component";
    private static final int DEFAULT_WEIGHT = 100;
    private volatile MarkupRendererComponent component;
    private int weight = 100;

    public MarkupRendererComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String weightAttr = element.attributeValue("weight");
        if (weightAttr != null) {
            try {
                this.weight = Integer.parseInt(weightAttr);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("The 'weight' attribute must be a number.", (Throwable)e);
            }
        }
    }

    @Override
    public int compareTo(@Nonnull MarkupRendererComponentModuleDescriptor o) {
        return Integer.compare(this.weight, o.getWeight());
    }

    public void enabled() {
        super.enabled();
        this.component = (MarkupRendererComponent)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public void disabled() {
        this.component = null;
        super.disabled();
    }

    public MarkupRendererComponent getModule() {
        return this.component;
    }

    public int getWeight() {
        return this.weight;
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException(List.of("The render component class is required"));
        }
    }
}

