/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.markup.renderer;

import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

public class RenderContext {
    private final String baseUrl;
    private final Map<String, Object> data;

    public RenderContext(String baseUrl) {
        this(baseUrl, (Map<String, Object>)ImmutableMap.of());
    }

    public RenderContext(String baseUrl, Map<String, Object> data) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
        this.data = ImmutableMap.copyOf(data);
    }

    @Nonnull
    public String createHostUrl(@Nonnull String path) {
        return this.appendUrlPath(path);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    private String appendUrlPath(String path) {
        if (this.baseUrl.endsWith("/") && ((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        } else if (!this.baseUrl.endsWith("/") && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return this.baseUrl + (String)path;
    }

    public static class Builder {
        private String baseUrl = "";
        private Map<String, Object> data = ImmutableMap.of();

        public RenderContext build() {
            return new RenderContext(this.baseUrl, this.data);
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }
    }
}

