/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.markup.renderer;

import com.atlassian.bitbucket.dmz.markup.renderer.Replacement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class RenderTransform {
    private final List<Replacement> replacements;

    public RenderTransform(List<Replacement> replacements) {
        this.replacements = ImmutableList.copyOf(replacements);
    }

    public static TransformBuilder builder() {
        return new TransformBuilder();
    }

    public Iterable<Replacement> getReplacements() {
        return this.replacements;
    }

    public RenderTransform immediate() {
        return new RenderTransform(Lists.transform(this.replacements, Replacement::immediate));
    }

    public String toString() {
        return "RenderTransform{replacements=" + String.valueOf(this.replacements) + "}";
    }

    public static class TransformBuilder {
        private final ImmutableList.Builder<Replacement> replacements = ImmutableList.builder();

        public TransformBuilder add(int start, int end, String value) {
            this.replacements.add((Object)new Replacement(start, end, value));
            return this;
        }

        public RenderTransform build() {
            return new RenderTransform((List<Replacement>)this.replacements.build());
        }
    }
}

