/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.notification.pull;

import com.atlassian.bitbucket.dmz.notification.pull.AbstractPullRequestNotification;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class PullRequestUpdatedNotification
extends AbstractPullRequestNotification {
    private final String previousDescription;
    private final boolean previousDraft;
    private final String previousTitle;
    private final Ref previousToBranch;

    public PullRequestUpdatedNotification(@Nonnull PullRequest pullRequest, @Nonnull Date whenActivityPerformed, @Nullable ApplicationUser activityPerformer, boolean previousDraft, @Nonnull String previousTitle, @Nullable String previousDescription, @Nullable Ref previousToBranch) {
        super(pullRequest, whenActivityPerformed, activityPerformer);
        this.previousDraft = previousDraft;
        this.previousTitle = Objects.requireNonNull(previousTitle, "previousTitle");
        this.previousDescription = previousDescription;
        this.previousToBranch = previousToBranch;
    }

    @Nonnull
    public String getPreviousTitle() {
        return this.previousTitle;
    }

    @Nullable
    public String getPreviousDescription() {
        return this.previousDescription;
    }

    @Nullable
    public Ref getPreviousToBranch() {
        return this.previousToBranch;
    }

    public boolean isPreviousDraft() {
        return this.previousDraft;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + super.toString() + ", previousTitle=" + this.previousTitle + ", previousDescription=" + this.previousDescription + ", previousDraft=" + this.previousDraft + ", previousToBranch=" + String.valueOf(this.previousToBranch) + "}";
    }
}

