/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.notification.repository;

import com.atlassian.bitbucket.dmz.notification.repository.AbstractRepositoryNotification;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.DetailedRefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;

public class RepositoryPushNotification
extends AbstractRepositoryNotification {
    private final Branch defaultBranch;
    private final boolean hasExtraRefChanges;
    private final Collection<DetailedRefChange> refChanges;

    public RepositoryPushNotification(@Nullable ApplicationUser user, @Nonnull Date timestamp, @Nonnull Repository repository, @Nullable Branch defaultBranch, boolean hasExtraRefChanges, @Nonnull Collection<DetailedRefChange> refChanges) {
        super(user, timestamp, repository);
        this.defaultBranch = defaultBranch;
        this.hasExtraRefChanges = hasExtraRefChanges;
        this.refChanges = refChanges;
    }

    @Nonnull
    public Optional<Branch> getDefaultBranch() {
        return Optional.ofNullable(this.defaultBranch);
    }

    @Nonnull
    public Optional<DetailedRefChange> getDefaultBranchChange() {
        if (this.defaultBranch == null) {
            return Optional.empty();
        }
        return this.refChanges.stream().filter(change -> this.defaultBranch.getId().equals(change.getRef().getId())).findAny();
    }

    @Nonnull
    public Collection<DetailedRefChange> getRefChanges() {
        return this.refChanges;
    }

    public boolean hasExtraRefChanges() {
        return this.hasExtraRefChanges;
    }
}

