/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.signature.verification;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class SignatureVerificationRequest {
    private final Date objectTimestamp;
    private final String signature;
    private final String signedContent;

    private SignatureVerificationRequest(Builder builder) {
        this.objectTimestamp = builder.objectTimestamp;
        this.signature = builder.signature;
        this.signedContent = builder.signedContent;
    }

    @Nonnull
    public Optional<Date> getObjectTimestamp() {
        return Optional.ofNullable(this.objectTimestamp);
    }

    @Nonnull
    public String getSignature() {
        return this.signature;
    }

    @Nonnull
    public String getSignedContent() {
        return this.signedContent;
    }

    public static class Builder {
        private final String signature;
        private final String signedContent;
        private Date objectTimestamp;

        public Builder(@Nonnull String signature, @Nonnull String signedContent) {
            this.signature = Objects.requireNonNull(signature, "signature");
            this.signedContent = Objects.requireNonNull(signedContent, "signedContent");
        }

        @Nonnull
        public SignatureVerificationRequest build() {
            return new SignatureVerificationRequest(this);
        }

        @Nonnull
        public Builder objectTimestamp(@Nullable Date value) {
            this.objectTimestamp = value;
            return this;
        }
    }
}

