/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.server.BaseUrlChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.repository.shortcut.NoSuchRepositoryShortcutException;
import com.atlassian.bitbucket.internal.repository.shortcut.RepositoryShortcutLimitExceededException;
import com.atlassian.bitbucket.internal.repository.shortcut.RepositoryShortcutService;
import com.atlassian.bitbucket.internal.repository.shortcut.dao.RepositoryShortcutDao;
import com.atlassian.bitbucket.internal.repository.shortcut.event.RepositoryShortcutAddedEvent;
import com.atlassian.bitbucket.internal.repository.shortcut.event.RepositoryShortcutDeletedEvent;
import com.atlassian.bitbucket.internal.repository.shortcut.event.RepositoryShortcutUpdatedEvent;
import com.atlassian.bitbucket.internal.repository.shortcut.model.ProductType;
import com.atlassian.bitbucket.internal.repository.shortcut.model.RepositoryShortcut;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DefaultRepositoryShortcutService
implements RepositoryShortcutService {
    private static final Set<String> DEFAULT_URL_SCHEME_WHITELIST = ImmutableSet.of((Object)"http://", (Object)"https://", (Object)"ftp://", (Object)"ftps://", (Object)"mailto:", (Object)"skype:", (Object[])new String[]{"callto:", "facetime:", "git:", "irc:", "irc6:", "news:", "nntp:", "feed:", "cvs:", "svn:", "mvn:", "ssh:", "itms:", "notes:", "smb:", "hipchat://", "sourcetree:", "urn:", "tel:", "xmpp:", "telnet:", "vnc:", "rdp:", "whatsapp:", "slack:", "sip:", "sips:", "magnet:"});
    private final ApplicationLinkService applicationLinkService;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryLock repositoryLock;
    private final RepositoryShortcutDao repositoryShortcutDao;
    private final TransactionTemplate transactionTemplate;
    private final Set<String> urlSchemeWhitelist;

    public DefaultRepositoryShortcutService(ApplicationLinkService applicationLinkService, ApplicationPropertiesService applicationPropertiesService, EventPublisher eventPublisher, I18nService i18nService, LockService lockService, PermissionValidationService permissionValidationService, RepositoryShortcutDao repositoryShortcutDao, TransactionTemplate transactionTemplate) {
        this.applicationLinkService = applicationLinkService;
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryShortcutDao = repositoryShortcutDao;
        this.transactionTemplate = transactionTemplate;
        this.repositoryLock = lockService.getRepositoryLock("repository-shortcuts");
        this.urlSchemeWhitelist = this.createUrlSchemeWhitelist();
    }

    @Override
    @Nonnull
    public RepositoryShortcut create(@Nonnull Repository repository, @Nonnull String label, @Nonnull String url) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_ADMIN);
        this.checkShortcutParameters(label, url);
        return (RepositoryShortcut)this.repositoryLock.withLock(repository, () -> (RepositoryShortcut)this.transactionTemplate.execute(() -> {
            if (this.repositoryShortcutDao.countForRepository(repository.getId()) >= 25) {
                throw new RepositoryShortcutLimitExceededException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.limit.max", new Object[]{25}));
            }
            ShortcutUrlDetails shortcutUrlDetails = this.getUrlDetails(url);
            RepositoryShortcut shortcut = this.repositoryShortcutDao.create(repository.getId(), shortcutUrlDetails.getApplicationLinkId(), new Date(), label, shortcutUrlDetails.getProductType(), shortcutUrlDetails.getUrl());
            this.eventPublisher.publish((Object)new RepositoryShortcutAddedEvent(this, shortcut));
            return shortcut;
        }));
    }

    @Override
    public void delete(@Nonnull Repository repository, int id) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_ADMIN);
        this.transactionTemplate.execute(() -> {
            RepositoryShortcut shortcut = this.repositoryShortcutDao.getById(id).orElseThrow(() -> new NoSuchRepositoryShortcutException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.notfound", new Object[]{id}), id));
            this.checkRepository(repository, shortcut);
            if (this.repositoryShortcutDao.delete(id)) {
                this.eventPublisher.publish((Object)new RepositoryShortcutDeletedEvent(this, shortcut));
            }
            return null;
        });
    }

    @Override
    public void deleteAll(@Nonnull Repository repository) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_ADMIN);
        this.transactionTemplate.execute(() -> this.repositoryShortcutDao.deleteAllForRepository(repository.getId()));
    }

    @Override
    @Nonnull
    public Page<RepositoryShortcut> findAll(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        this.permissionValidationService.validateRepositoryAccessible(Objects.requireNonNull(repository, "repository"));
        Objects.requireNonNull(pageRequest, "pageRequest");
        return (Page)this.transactionTemplate.execute(() -> this.repositoryShortcutDao.findByRepository(repository.getId(), pageRequest));
    }

    @Override
    @Nonnull
    public Set<String> getUrlSchemeWhitelist() {
        return this.urlSchemeWhitelist;
    }

    @EventListener
    public void onApplicationLinkAddedEvent(@Nonnull ApplicationLinkAddedEvent event) {
        Objects.requireNonNull(event, "event");
        ApplicationLink applicationLink = event.getApplicationLink();
        String applinkUrl = applicationLink.getDisplayUrl().toString();
        this.transactionTemplate.execute(() -> {
            Stream<RepositoryShortcut> shortcuts = PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByUrlStartingWith(applinkUrl, pageRequest), (int)25).filter(shortcut -> DefaultRepositoryShortcutService.isUrlPrefix(applinkUrl, shortcut.getUrl())).filter(shortcut -> shortcut.getApplicationLinkId() == null);
            this.updateShortcuts(shortcuts, shortcut -> new ShortcutUrlDetails.Builder(this.getProductType(applicationLink), shortcut.getUrl()).applicationLinkId(applicationLink.getId().get()).build());
            return null;
        });
    }

    @EventListener
    public void onApplicationLinkDeletedEvent(@Nonnull ApplicationLinkDeletedEvent event) {
        this.transactionTemplate.execute(() -> {
            Stream shortcuts = PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByApplicationLinkId(event.getApplicationId().get(), pageRequest), (int)25);
            this.updateShortcuts(shortcuts, shortcut -> {
                ProductType productType = this.getProductType(shortcut.getUrl()).orElse(ProductType.OTHER);
                return new ShortcutUrlDetails.Builder(productType, shortcut.getUrl()).build();
            });
            return null;
        });
    }

    @EventListener
    public void onApplicationLinkDetailsChangedEvent(@Nonnull ApplicationLinkDetailsChangedEvent event) {
        ApplicationLink applicationLink = event.getApplicationLink();
        String applinkUrl = applicationLink.getDisplayUrl().toString();
        this.transactionTemplate.execute(() -> {
            Stream<RepositoryShortcut> shortcuts = PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByApplicationLinkId(applicationLink.getId().get(), pageRequest), (int)25).filter(shortcut -> !DefaultRepositoryShortcutService.isUrlPrefix(applinkUrl, shortcut.getUrl()));
            this.updateShortcuts(shortcuts, shortcut -> new ShortcutUrlDetails.Builder(ProductType.OTHER, shortcut.getUrl()).build());
            shortcuts = PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByUrlStartingWith(applinkUrl, pageRequest), (int)25).filter(shortcut -> DefaultRepositoryShortcutService.isUrlPrefix(applinkUrl, shortcut.getUrl())).filter(shortcut -> shortcut.getApplicationLinkId() == null);
            this.updateShortcuts(shortcuts, shortcut -> new ShortcutUrlDetails.Builder(this.getProductType(applicationLink), shortcut.getUrl()).applicationLinkId(applicationLink.getId().get()).build());
            return null;
        });
    }

    @EventListener
    public void onBaseUrlChangedEvent(@Nonnull BaseUrlChangedEvent event) {
        String oldBaseUrl = (String)event.getOldValue();
        String newBaseUrl = event.getNewValue();
        this.transactionTemplate.execute(() -> {
            if (oldBaseUrl == null) {
                Stream shortcuts = PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByUrlStartingWith(newBaseUrl, pageRequest), (int)25);
                this.updateShortcuts(shortcuts, shortcut -> new ShortcutUrlDetails.Builder(ProductType.BITBUCKET_SERVER, shortcut.getUrl()).build());
            } else {
                Stream<RepositoryShortcut> shortcuts = Stream.concat(PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByUrlStartingWith(oldBaseUrl, pageRequest), (int)25), PageUtils.toStream(pageRequest -> this.repositoryShortcutDao.findByUrlStartingWith(newBaseUrl, pageRequest), (int)25));
                this.updateShortcuts(shortcuts, shortcut -> {
                    String updatedUrl = StringUtils.replace((String)shortcut.getUrl(), (String)oldBaseUrl, (String)newBaseUrl);
                    return new ShortcutUrlDetails.Builder(ProductType.BITBUCKET_SERVER, updatedUrl).build();
                });
            }
            return null;
        });
    }

    @EventListener
    public void onRepositoryDeleted(@Nonnull RepositoryDeletedEvent event) {
        this.transactionTemplate.execute(() -> this.repositoryShortcutDao.deleteAllForRepository(event.getRepository().getId()));
    }

    @Override
    @Nonnull
    public RepositoryShortcut update(@Nonnull Repository repository, int id, @Nonnull String label, @Nonnull String url) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_ADMIN);
        this.checkShortcutParameters(label, url);
        return (RepositoryShortcut)this.transactionTemplate.execute(() -> {
            RepositoryShortcut shortcut = this.repositoryShortcutDao.getById(id).orElseThrow(() -> new NoSuchRepositoryShortcutException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.notfound", new Object[]{id}), id));
            this.checkRepository(repository, shortcut);
            ShortcutUrlDetails shortcutUrlDetails = shortcut.getUrl().equals(url) ? new ShortcutUrlDetails.Builder(shortcut).build() : this.getUrlDetails(url);
            return this.internalUpdate(shortcut, label, shortcutUrlDetails);
        });
    }

    private static boolean isUrlPrefix(String prefixUrl, String url) {
        return url.equals(prefixUrl) || url.startsWith(prefixUrl + "/");
    }

    private void checkRepository(Repository repository, RepositoryShortcut shortcut) {
        if (repository.getId() != shortcut.getRepositoryId()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.invalid.repo", new Object[]{shortcut.getId(), repository.getId()}));
        }
    }

    private void checkShortcutParameters(String label, String url) {
        Objects.requireNonNull(label, "label");
        Objects.requireNonNull(url, "url");
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.label.empty", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.url.empty", new Object[0]));
        }
        if (label.length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.label.toolong", new Object[]{255}));
        }
        if (url.length() > 450) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.url.toolong", new Object[]{450}));
        }
        if (this.urlSchemeWhitelist.stream().noneMatch(url::startsWith)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.url.invalidscheme", new Object[0]));
        }
    }

    private Set<String> createUrlSchemeWhitelist() {
        String extendedUrlWhitelist = this.applicationPropertiesService.getPluginProperty("plugin.repository.shortcut.url.scheme.extended.whitelist", "");
        if (StringUtils.isBlank((CharSequence)extendedUrlWhitelist)) {
            return DEFAULT_URL_SCHEME_WHITELIST;
        }
        return ImmutableSet.builder().addAll(DEFAULT_URL_SCHEME_WHITELIST).add((Object[])extendedUrlWhitelist.split(",")).build();
    }

    private ProductType getProductType(ApplicationLink applicationLink) {
        String applicationLinkType = this.i18nService.getMessagePattern(applicationLink.getType().getI18nKey());
        return applicationLinkType == null ? ProductType.OTHER : ProductType.fromString(applicationLinkType, ProductType.OTHER);
    }

    private Optional<ProductType> getProductType(String url) {
        String host;
        try {
            host = new URI(url).getHost();
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
        if (StringUtils.isNotBlank((CharSequence)host)) {
            if (host.endsWith("bitbucket.org")) {
                return Optional.of(ProductType.BITBUCKET_CLOUD);
            }
            if (host.endsWith("hipchat.com")) {
                return Optional.of(ProductType.HIPCHAT);
            }
            if (host.endsWith("trello.com")) {
                return Optional.of(ProductType.TRELLO);
            }
        }
        return Optional.empty();
    }

    private ShortcutUrlDetails getUrlDetails(String url) {
        if (DefaultRepositoryShortcutService.isUrlPrefix(Objects.toString(this.applicationPropertiesService.getBaseUrl()), url)) {
            return new ShortcutUrlDetails.Builder(ProductType.BITBUCKET_SERVER, url).build();
        }
        return this.getProductType(url).map(productType -> new ShortcutUrlDetails.Builder((ProductType)((Object)productType), url).build()).orElseGet(() -> MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks()).filter(appLink -> DefaultRepositoryShortcutService.isUrlPrefix(appLink.getDisplayUrl().toString(), url)).findFirst().map(applicationLink -> new ShortcutUrlDetails.Builder(this.getProductType((ApplicationLink)applicationLink), url).applicationLinkId(applicationLink.getId().get()).build()).orElseGet(() -> new ShortcutUrlDetails.Builder(ProductType.OTHER, url).build()));
    }

    private RepositoryShortcut internalUpdate(RepositoryShortcut shortcut, String label, ShortcutUrlDetails shortcutUrlDetails) {
        RepositoryShortcut updated = this.repositoryShortcutDao.update(shortcut, shortcutUrlDetails.getApplicationLinkId(), label, shortcutUrlDetails.getProductType(), shortcutUrlDetails.getUrl());
        this.eventPublisher.publish((Object)new RepositoryShortcutUpdatedEvent(this, updated));
        return updated;
    }

    private void updateShortcuts(Stream<RepositoryShortcut> shortcuts, Function<RepositoryShortcut, ShortcutUrlDetails> update) {
        shortcuts.forEach(shortcut -> {
            ShortcutUrlDetails shortcutUrlDetails = (ShortcutUrlDetails)update.apply((RepositoryShortcut)shortcut);
            this.internalUpdate((RepositoryShortcut)shortcut, shortcut.getLabel(), shortcutUrlDetails);
        });
    }

    private static class ShortcutUrlDetails {
        private final String applicationLinkId;
        private final ProductType productType;
        private final String url;

        private ShortcutUrlDetails(@Nonnull Builder builder) {
            this.applicationLinkId = builder.applicationLinkId;
            this.productType = builder.productType;
            this.url = builder.url;
        }

        @Nullable
        private String getApplicationLinkId() {
            return this.applicationLinkId;
        }

        @Nonnull
        private ProductType getProductType() {
            return this.productType;
        }

        @Nonnull
        private String getUrl() {
            return this.url;
        }

        private static class Builder {
            private final ProductType productType;
            private final String url;
            private String applicationLinkId;

            private Builder(@Nonnull RepositoryShortcut shortcut) {
                this.applicationLinkId = Objects.requireNonNull(shortcut, "shortcut").getApplicationLinkId();
                this.productType = shortcut.getProductType();
                this.url = shortcut.getUrl();
            }

            private Builder(@Nonnull ProductType productType, @Nonnull String url) {
                this.productType = Objects.requireNonNull(productType, "productType");
                this.url = Objects.requireNonNull(url, "url");
            }

            private Builder applicationLinkId(@Nullable String value) {
                this.applicationLinkId = value;
                return this;
            }

            private ShortcutUrlDetails build() {
                return new ShortcutUrlDetails(this);
            }
        }
    }
}

