/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.repository.shortcut.NoSuchRepositoryShortcutException;
import com.atlassian.bitbucket.internal.repository.shortcut.dao.AoRepositoryShortcut;
import com.atlassian.bitbucket.internal.repository.shortcut.dao.RepositoryShortcutDao;
import com.atlassian.bitbucket.internal.repository.shortcut.model.ProductType;
import com.atlassian.bitbucket.internal.repository.shortcut.model.RepositoryShortcut;
import com.atlassian.bitbucket.internal.repository.shortcut.model.SimpleRepositoryShortcut;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import net.java.ao.Query;

public class AoRepositoryShortcutDao
extends AbstractAoDao
implements RepositoryShortcutDao {
    private final I18nService i18nService;

    public AoRepositoryShortcutDao(ActiveObjects ao, I18nService i18nService) {
        super(ao);
        this.i18nService = i18nService;
    }

    @Override
    public int countForRepository(int repositoryId) {
        return this.ao.count(AoRepositoryShortcut.class, "REPOSITORY_ID = ?", new Object[]{repositoryId});
    }

    @Override
    @Nonnull
    public SimpleRepositoryShortcut create(int repositoryId, @Nullable String applicationLinkId, @Nonnull Date createdDate, @Nonnull String label, @Nonnull ProductType productType, @Nonnull String url) {
        HashMap<String, Object> creationMap = new HashMap<String, Object>();
        creationMap.put("APPLICATION_LINK_ID", applicationLinkId);
        creationMap.put("CREATED_DATE", createdDate);
        creationMap.put("LABEL", label);
        creationMap.put("PRODUCT_TYPE", (Object)productType);
        creationMap.put("REPOSITORY_ID", repositoryId);
        creationMap.put("URL", url);
        return new SimpleRepositoryShortcut((AoRepositoryShortcut)this.ao.create(AoRepositoryShortcut.class, creationMap));
    }

    @Override
    public boolean delete(int shortcutId) {
        return this.ao.deleteWithSQL(AoRepositoryShortcut.class, "ID = ?", new Object[]{shortcutId}) > 0;
    }

    @Override
    public int deleteAllForRepository(int repositoryId) {
        return this.ao.deleteWithSQL(AoRepositoryShortcut.class, "REPOSITORY_ID = ?", new Object[]{repositoryId});
    }

    @Override
    @Nonnull
    public Page<RepositoryShortcut> findByApplicationLinkId(@Nonnull String applicationLinkId, @Nonnull PageRequest pageRequest) {
        Query query = Query.select().where("APPLICATION_LINK_ID = ? ", new Object[]{applicationLinkId}).order("CREATED_DATE ASC");
        return this.pageQuery(AoRepositoryShortcut.class, query, pageRequest).transform(SimpleRepositoryShortcut::new);
    }

    @Override
    @Nonnull
    public Page<RepositoryShortcut> findByRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        Query query = Query.select().where("REPOSITORY_ID = ? ", new Object[]{repositoryId}).order("CREATED_DATE ASC");
        return this.pageQuery(AoRepositoryShortcut.class, query, pageRequest).transform(SimpleRepositoryShortcut::new);
    }

    @Override
    @Nonnull
    public Page<RepositoryShortcut> findByUrlStartingWith(@Nonnull String urlPrefix, @Nonnull PageRequest pageRequest) {
        Query query = Query.select().where("URL LIKE ? ", new Object[]{urlPrefix + "%"}).order("CREATED_DATE ASC");
        return this.pageQuery(AoRepositoryShortcut.class, query, pageRequest).transform(SimpleRepositoryShortcut::new);
    }

    @Override
    @Nonnull
    public Optional<RepositoryShortcut> getById(int shortcutId) {
        return this.internalGetById(shortcutId).map(SimpleRepositoryShortcut::new);
    }

    @Override
    @Nonnull
    public SimpleRepositoryShortcut update(@Nonnull RepositoryShortcut shortcut, @Nullable String applicationLinkId, @Nonnull String label, @Nonnull ProductType productType, @Nonnull String url) {
        AoRepositoryShortcut aoShortcut = this.internalGetById(shortcut.getId()).orElseThrow(() -> new NoSuchRepositoryShortcutException(this.i18nService.createKeyedMessage("bitbucket.repository.shortcut.notfound", new Object[]{shortcut.getId()}), shortcut.getId()));
        aoShortcut.setApplicationLinkId(applicationLinkId);
        aoShortcut.setLabel(label);
        aoShortcut.setProductType(productType);
        aoShortcut.setUrl(url);
        aoShortcut.save();
        return new SimpleRepositoryShortcut(aoShortcut);
    }

    private Optional<AoRepositoryShortcut> internalGetById(int shortcutId) {
        AoRepositoryShortcut[] results = (AoRepositoryShortcut[])this.ao.find(AoRepositoryShortcut.class, "ID = ?", new Object[]{shortcutId});
        return results == null || results.length == 0 ? Optional.empty() : Optional.of(results[0]);
    }
}

