/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut.model;

import jakarta.annotation.Nullable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProductType {
    BAMBOO,
    BITBUCKET_CLOUD,
    BITBUCKET_SERVER,
    CONFLUENCE,
    HIPCHAT,
    JIRA,
    OTHER,
    TRELLO;

    private static final Logger log;

    public static ProductType fromString(@Nullable String stringValue, @Nullable ProductType defaultValue) {
        try {
            return ProductType.valueOf(StringUtils.upperCase((String)stringValue, (Locale)Locale.ROOT));
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            log.debug("There is no valid repository shortcut product type for {}", (Object)stringValue);
            return defaultValue;
        }
    }

    static {
        log = LoggerFactory.getLogger(ProductType.class);
    }
}

