/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.repository.shortcut.RepositoryShortcutService;
import com.atlassian.bitbucket.internal.repository.shortcut.model.RepositoryShortcut;
import com.atlassian.bitbucket.internal.repository.shortcut.rest.RestRepositoryShortcut;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Produces(value={"application/json"})
@Singleton
public class RepositoryShortcutResource {
    private final RepositoryShortcutService repositoryShortcutService;

    @Inject
    public RepositoryShortcutResource(RepositoryShortcutService repositoryShortcutService) {
        this.repositoryShortcutService = repositoryShortcutService;
    }

    @POST
    @Path(value="shortcuts")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(@BeanParam RepositoryResolver repository, RestRepositoryShortcut shortcut) {
        RepositoryShortcut created = this.repositoryShortcutService.create(repository.getRepository(), shortcut.getLabel(), shortcut.getUrl());
        return ResponseFactory.ok((Object)((Object)new RestRepositoryShortcut(created))).build();
    }

    @DELETE
    @Path(value="shortcuts/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="id") int id) {
        this.repositoryShortcutService.delete(repositoryResolver.getRepository(), id);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="shortcuts")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page<RepositoryShortcut> shortcuts = this.repositoryShortcutService.findAll(repositoryResolver.getRepository(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(shortcuts, RestRepositoryShortcut::new)).build();
    }

    @PUT
    @Path(value="shortcuts/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response update(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="id") int id, RestRepositoryShortcut shortcut) {
        RepositoryShortcut updated = this.repositoryShortcutService.update(repositoryResolver.getRepository(), id, shortcut.getLabel(), shortcut.getUrl());
        return ResponseFactory.ok((Object)((Object)new RestRepositoryShortcut(updated))).build();
    }
}

