/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut.rest;

import com.atlassian.bitbucket.internal.repository.shortcut.model.ProductType;
import com.atlassian.bitbucket.internal.repository.shortcut.model.RepositoryShortcut;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@JsonSurrogate(value=RepositoryShortcut.class)
public class RestRepositoryShortcut
extends RestMapEntity {
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String PRODUCT_TYPE = "productType";
    private static final String URL = "url";

    public RestRepositoryShortcut() {
    }

    public RestRepositoryShortcut(RepositoryShortcut shortcut) {
        this(shortcut.getId(), shortcut.getLabel(), shortcut.getProductType(), shortcut.getUrl());
    }

    private RestRepositoryShortcut(int id, String label, ProductType productType, String url) {
        if (id > 0) {
            this.put(ID, id);
        }
        this.put(LABEL, label);
        if (productType != null) {
            this.put(PRODUCT_TYPE, productType.name());
        }
        this.put(URL, url);
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    @Nonnull
    public String getLabel() {
        return StringUtils.defaultString((String)this.getStringProperty(LABEL), (String)"");
    }

    @Nonnull
    public ProductType getProductType() {
        return (ProductType)this.getEnumProperty(PRODUCT_TYPE, ProductType.class);
    }

    @Nonnull
    public String getUrl() {
        return StringUtils.defaultString((String)this.getStringProperty(URL), (String)"");
    }
}

