/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repository.shortcut.web;

import com.atlassian.bitbucket.internal.repository.shortcut.RepositoryShortcutService;
import com.atlassian.bitbucket.internal.repository.shortcut.model.ProductType;
import com.atlassian.bitbucket.internal.repository.shortcut.model.RepositoryShortcut;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.plugin.web.model.WebFragmentBuilder;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class RepositoryShortcutWebItemProvider
implements WebItemProvider {
    private static final String WEB_ITEM_KEY = "bitbucket.web.sidebar.repository.nav.shortcut:repository-shortcut-";
    private static final int INITIAL_WEIGHT = 10;
    private final RepositoryShortcutService repositoryShortcutService;

    public RepositoryShortcutWebItemProvider(RepositoryShortcutService repositoryShortcutService) {
        this.repositoryShortcutService = repositoryShortcutService;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        Object object = context.get("repository");
        if (object instanceof Repository) {
            Repository repository = (Repository)object;
            MutableInt weight = new MutableInt(10);
            return (Iterable)PageUtils.toStream(pageRequest -> this.repositoryShortcutService.findAll(repository, pageRequest), (int)25).map(shortcut -> RepositoryShortcutWebItemProvider.createWebItem(shortcut, weight.getAndAdd(10))).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }

    private static WebItem createWebItem(RepositoryShortcut shortcut, int weight) {
        return new WebFragmentBuilder(WEB_ITEM_KEY + shortcut.getId(), weight).id("repo-shortcut-url-" + shortcut.getId()).label(shortcut.getLabel()).addParam("actionLocation", "bitbucket.web.sidebar.repository.nav.shortcut.action").addParam("iconClass", "aui-icon-small " + RepositoryShortcutWebItemProvider.getIconType(shortcut.getProductType())).webItem("bitbucket.repository.nav/bitbucket.web.sidebar.repository.nav.shortcuts").url(shortcut.getUrl()).build();
    }

    private static String getIconType(ProductType productType) {
        switch (productType) {
            case BAMBOO: {
                return "icon-bamboo";
            }
            case BITBUCKET_CLOUD: 
            case BITBUCKET_SERVER: {
                return "icon-bitbucket";
            }
            case CONFLUENCE: {
                return "icon-confluence";
            }
            case HIPCHAT: {
                return "icon-hipchat";
            }
            case JIRA: {
                return "icon-jira";
            }
            case TRELLO: {
                return "icon-trello";
            }
        }
        return "icon-link";
    }
}

