/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ImageReference;

public enum KnownLinuxVirtualMachineImage {
    UBUNTU_SERVER_14_04_LTS("Canonical", "UbuntuServer", "14.04.4-LTS"),
    UBUNTU_SERVER_16_04_LTS("Canonical", "UbuntuServer", "16.04.0-LTS"),
    UBUNTU_SERVER_18_04_LTS("Canonical", "UbuntuServer", "18.04-LTS"),
    DEBIAN_9("credativ", "Debian", "9"),
    DEBIAN_10("Debian", "debian-10", "10"),
    CENTOS_8_1("OpenLogic", "CentOS", "8_1"),
    OPENSUSE_LEAP_15_1("SUSE", "openSUSE-Leap", "15-1"),
    SLES_15_SP1("SUSE", "sles-15-sp1", "gen1"),
    REDHAT_RHEL_8_2("RedHat", "RHEL", "8.2"),
    ORACLE_LINUX_8_1("Oracle", "Oracle-Linux", "81");

    private final String publisher;
    private final String offer;
    private final String sku;

    private KnownLinuxVirtualMachineImage(String publisher, String offer, String sku) {
        this.publisher = publisher;
        this.offer = offer;
        this.sku = sku;
    }

    public String publisher() {
        return this.publisher;
    }

    public String offer() {
        return this.offer;
    }

    public String sku() {
        return this.sku;
    }

    public ImageReference imageReference() {
        return new ImageReference().withPublisher(this.publisher()).withOffer(this.offer()).withSku(this.sku()).withVersion("latest");
    }
}

