/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DiskRestorePointInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DiskRestorePointsInner {
    private DiskRestorePointsService service;
    private ComputeManagementClientImpl client;

    public DiskRestorePointsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DiskRestorePointsService)retrofit.create(DiskRestorePointsService.class);
        this.client = client;
    }

    public DiskRestorePointInner get(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return (DiskRestorePointInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).toBlocking().single()).body();
    }

    public ServiceFuture<DiskRestorePointInner> getAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, ServiceCallback<DiskRestorePointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName), serviceCallback);
    }

    public Observable<DiskRestorePointInner> getAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return this.getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).map((Func1)new Func1<ServiceResponse<DiskRestorePointInner>, DiskRestorePointInner>(){

            public DiskRestorePointInner call(ServiceResponse<DiskRestorePointInner> response) {
                return (DiskRestorePointInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiskRestorePointInner>> getWithServiceResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (restorePointCollectionName == null) {
            throw new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null.");
        }
        if (vmRestorePointName == null) {
            throw new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null.");
        }
        if (diskRestorePointName == null) {
            throw new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskRestorePointInner>>>(){

            public Observable<ServiceResponse<DiskRestorePointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskRestorePointsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskRestorePointInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskRestorePointInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskRestorePointInner> listByRestorePoint(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        ServiceResponse response = (ServiceResponse)this.listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName).toBlocking().single();
        return new PagedList<DiskRestorePointInner>((Page)response.body()){

            public Page<DiskRestorePointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskRestorePointsInner.this.listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskRestorePointInner>> listByRestorePointAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, ListOperationCallback<DiskRestorePointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(String nextPageLink) {
                return DiskRestorePointsInner.this.listByRestorePointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskRestorePointInner>> listByRestorePointAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return this.listByRestorePointWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName).map((Func1)new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Page<DiskRestorePointInner>>(){

            public Page<DiskRestorePointInner> call(ServiceResponse<Page<DiskRestorePointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointWithServiceResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return this.listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName).concatMap((Func1)new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(ServiceResponse<Page<DiskRestorePointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskRestorePointsInner.this.listByRestorePointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointSinglePageAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (restorePointCollectionName == null) {
            throw new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null.");
        }
        if (vmRestorePointName == null) {
            throw new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.listByRestorePoint(this.client.subscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskRestorePointsInner.this.listByRestorePointDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskRestorePointInner>> listByRestorePointDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskRestorePointInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskRestorePointInner> listByRestorePointNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskRestorePointInner>((Page)response.body()){

            public Page<DiskRestorePointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskRestorePointsInner.this.listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskRestorePointInner>> listByRestorePointNextAsync(String nextPageLink, ServiceFuture<List<DiskRestorePointInner>> serviceFuture, ListOperationCallback<DiskRestorePointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRestorePointNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(String nextPageLink) {
                return DiskRestorePointsInner.this.listByRestorePointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskRestorePointInner>> listByRestorePointNextAsync(String nextPageLink) {
        return this.listByRestorePointNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Page<DiskRestorePointInner>>(){

            public Page<DiskRestorePointInner> call(ServiceResponse<Page<DiskRestorePointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByRestorePointNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(ServiceResponse<Page<DiskRestorePointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskRestorePointsInner.this.listByRestorePointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByRestorePointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>(){

            public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskRestorePointsInner.this.listByRestorePointNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskRestorePointInner>> listByRestorePointNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskRestorePointInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DiskRestorePointsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="restorePointCollectionName") String var3, @Path(value="vmRestorePointName") String var4, @Path(value="diskRestorePointName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints listByRestorePoint"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints")
        public Observable<Response<ResponseBody>> listByRestorePoint(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="restorePointCollectionName") String var3, @Path(value="vmRestorePointName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints listByRestorePointNext"})
        @GET
        public Observable<Response<ResponseBody>> listByRestorePointNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

