/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.SshPublicKeyUpdateResource;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.SshPublicKeyGenerateKeyPairResultInner;
import com.microsoft.azure.management.compute.implementation.SshPublicKeyResourceInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SshPublicKeysInner
implements InnerSupportsGet<SshPublicKeyResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<SshPublicKeyResourceInner> {
    private SshPublicKeysService service;
    private ComputeManagementClientImpl client;

    public SshPublicKeysInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (SshPublicKeysService)retrofit.create(SshPublicKeysService.class);
        this.client = client;
    }

    public PagedList<SshPublicKeyResourceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>((Page)response.body()){

            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SshPublicKeysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SshPublicKeyResourceInner>> listAsync(ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                return SshPublicKeysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SshPublicKeyResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>(){

            public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SshPublicKeysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.list(this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SshPublicKeysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SshPublicKeyResourceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>((Page)response.body()){

            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SshPublicKeysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SshPublicKeyResourceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                return SshPublicKeysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SshPublicKeyResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>(){

            public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SshPublicKeysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SshPublicKeysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SshPublicKeyResourceInner create(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        return (SshPublicKeyResourceInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SshPublicKeyResourceInner> createAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters, ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters), serviceCallback);
    }

    public Observable<SshPublicKeyResourceInner> createAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).map((Func1)new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>(){

            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return (SshPublicKeyResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SshPublicKeyResourceInner>> createWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-12-01";
        return this.service.create(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), parameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>(){

            public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SshPublicKeysInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SshPublicKeyResourceInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SshPublicKeyResourceInner>(){}.getType()).register(201, new TypeToken<SshPublicKeyResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SshPublicKeyResourceInner update(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        return (SshPublicKeyResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SshPublicKeyResourceInner> updateAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters, ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters), serviceCallback);
    }

    public Observable<SshPublicKeyResourceInner> updateAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).map((Func1)new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>(){

            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return (SshPublicKeyResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SshPublicKeyResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-12-01";
        return this.service.update(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), parameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>(){

            public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SshPublicKeysInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SshPublicKeyResourceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SshPublicKeyResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String sshPublicKeyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String sshPublicKeyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String sshPublicKeyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.delete(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SshPublicKeysInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SshPublicKeyResourceInner getByResourceGroup(String resourceGroupName, String sshPublicKeyName) {
        return (SshPublicKeyResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single()).body());
    }

    public ServiceFuture<SshPublicKeyResourceInner> getByResourceGroupAsync(String resourceGroupName, String sshPublicKeyName, ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    public Observable<SshPublicKeyResourceInner> getByResourceGroupAsync(String resourceGroupName, String sshPublicKeyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map((Func1)new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>(){

            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return (SshPublicKeyResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SshPublicKeyResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.getByResourceGroup(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>(){

            public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SshPublicKeysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SshPublicKeyResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SshPublicKeyResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SshPublicKeyGenerateKeyPairResultInner generateKeyPair(String resourceGroupName, String sshPublicKeyName) {
        return (SshPublicKeyGenerateKeyPairResultInner)((ServiceResponse)this.generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single()).body();
    }

    public ServiceFuture<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairAsync(String resourceGroupName, String sshPublicKeyName, ServiceCallback<SshPublicKeyGenerateKeyPairResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    public Observable<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairAsync(String resourceGroupName, String sshPublicKeyName) {
        return this.generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map((Func1)new Func1<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>, SshPublicKeyGenerateKeyPairResultInner>(){

            public SshPublicKeyGenerateKeyPairResultInner call(ServiceResponse<SshPublicKeyGenerateKeyPairResultInner> response) {
                return (SshPublicKeyGenerateKeyPairResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>> generateKeyPairWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.generateKeyPair(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>>>(){

            public Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SshPublicKeysInner.this.generateKeyPairDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SshPublicKeyGenerateKeyPairResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SshPublicKeyResourceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>((Page)response.body()){

            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SshPublicKeysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SshPublicKeyResourceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<SshPublicKeyResourceInner>> serviceFuture, ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                return SshPublicKeysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SshPublicKeyResourceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>(){

            public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SshPublicKeysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SshPublicKeysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SshPublicKeyResourceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>((Page)response.body()){

            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SshPublicKeysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SshPublicKeyResourceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<SshPublicKeyResourceInner>> serviceFuture, ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                return SshPublicKeysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SshPublicKeyResourceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>(){

            public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SshPublicKeysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>(){

            public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SshPublicKeysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SshPublicKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/sshPublicKeys")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="sshPublicKeyName") String var2, @Path(value="subscriptionId") String var3, @Body SshPublicKeyResourceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="sshPublicKeyName") String var2, @Path(value="subscriptionId") String var3, @Body SshPublicKeyUpdateResource var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="sshPublicKeyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="sshPublicKeyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys generateKeyPair"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}/generateKeyPair")
        public Observable<Response<ResponseBody>> generateKeyPair(@Path(value="resourceGroupName") String var1, @Path(value="sshPublicKeyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

