/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineImagesEdgeZonesInner {
    private VirtualMachineImagesEdgeZonesService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineImagesEdgeZonesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineImagesEdgeZonesService)retrofit.create(VirtualMachineImagesEdgeZonesService.class);
        this.client = client;
    }

    public VirtualMachineImageInner get(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        return (VirtualMachineImageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, version).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineImageInner> getAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version, ServiceCallback<VirtualMachineImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, version), serviceCallback);
    }

    public Observable<VirtualMachineImageInner> getAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        return this.getWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, version).map((Func1)new Func1<ServiceResponse<VirtualMachineImageInner>, VirtualMachineImageInner>(){

            public VirtualMachineImageInner call(ServiceResponse<VirtualMachineImageInner> response) {
                return (VirtualMachineImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineImageInner>> getWithServiceResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.get(location, edgeZone, publisherName, offer, skus, version, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineImageInner>>>(){

            public Observable<ServiceResponse<VirtualMachineImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineImageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> list(String location, String edgeZone, String publisherName, String offer, String skus) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listAsync(String location, String edgeZone, String publisherName, String offer, String skus, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listAsync(String location, String edgeZone, String publisherName, String offer, String skus) {
        return this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listWithServiceResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        Integer top = null;
        String orderby = null;
        return this.service.list(location, edgeZone, publisherName, offer, skus, this.client.subscriptionId(), expand, top, orderby, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<VirtualMachineImageResourceInner> list(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, expand, top, orderby).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listAsync(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, expand, top, orderby), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listAsync(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        return this.listWithServiceResponseAsync(location, edgeZone, publisherName, offer, skus, expand, top, orderby).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listWithServiceResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.list(location, edgeZone, publisherName, offer, skus, this.client.subscriptionId(), expand, top, orderby, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listOffers(String location, String edgeZone, String publisherName) {
        return (List)((ServiceResponse)this.listOffersWithServiceResponseAsync(location, edgeZone, publisherName).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String edgeZone, String publisherName, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listOffersWithServiceResponseAsync(location, edgeZone, publisherName), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String edgeZone, String publisherName) {
        return this.listOffersWithServiceResponseAsync(location, edgeZone, publisherName).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listOffersWithServiceResponseAsync(String location, String edgeZone, String publisherName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listOffers(location, edgeZone, publisherName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.listOffersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listOffersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listPublishers(String location, String edgeZone) {
        return (List)((ServiceResponse)this.listPublishersWithServiceResponseAsync(location, edgeZone).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location, String edgeZone, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listPublishersWithServiceResponseAsync(location, edgeZone), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location, String edgeZone) {
        return this.listPublishersWithServiceResponseAsync(location, edgeZone).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listPublishersWithServiceResponseAsync(String location, String edgeZone) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listPublishers(location, edgeZone, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.listPublishersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listPublishersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listSkus(String location, String edgeZone, String publisherName, String offer) {
        return (List)((ServiceResponse)this.listSkusWithServiceResponseAsync(location, edgeZone, publisherName, offer).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String edgeZone, String publisherName, String offer, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSkusWithServiceResponseAsync(location, edgeZone, publisherName, offer), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String edgeZone, String publisherName, String offer) {
        return this.listSkusWithServiceResponseAsync(location, edgeZone, publisherName, offer).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listSkusWithServiceResponseAsync(String location, String edgeZone, String publisherName, String offer) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (edgeZone == null) {
            throw new IllegalArgumentException("Parameter edgeZone is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listSkus(location, edgeZone, publisherName, offer, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesEdgeZonesInner.this.listSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listSkusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineImagesEdgeZonesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImagesEdgeZones get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}")
        public Observable<Response<ResponseBody>> get(@Path(value="location") String var1, @Path(value="edgeZone") String var2, @Path(value="publisherName") String var3, @Path(value="offer") String var4, @Path(value="skus") String var5, @Path(value="version") String var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImagesEdgeZones list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="edgeZone") String var2, @Path(value="publisherName") String var3, @Path(value="offer") String var4, @Path(value="skus") String var5, @Path(value="subscriptionId") String var6, @Query(value="$expand") String var7, @Query(value="$top") Integer var8, @Query(value="$orderby") String var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImagesEdgeZones listOffers"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers")
        public Observable<Response<ResponseBody>> listOffers(@Path(value="location") String var1, @Path(value="edgeZone") String var2, @Path(value="publisherName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImagesEdgeZones listPublishers"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers")
        public Observable<Response<ResponseBody>> listPublishers(@Path(value="location") String var1, @Path(value="edgeZone") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImagesEdgeZones listSkus"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus")
        public Observable<Response<ResponseBody>> listSkus(@Path(value="location") String var1, @Path(value="edgeZone") String var2, @Path(value="publisherName") String var3, @Path(value="offer") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

