/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractAccessToken
implements AccessToken {
    private final Date createdDate;
    private final Integer expiryDays;
    private final Date lastAuthenticated;
    private final String name;
    private final Set<Permission> permissions;
    private final String tokenId;
    private final ApplicationUser user;

    protected AbstractAccessToken(AbstractBuilder<?> builder) {
        this.lastAuthenticated = builder.lastAuthenticated;
        this.createdDate = builder.createdDate;
        this.expiryDays = builder.expiryDays;
        this.name = builder.name;
        this.permissions = builder.permissions.build();
        this.tokenId = builder.tokenId;
        this.user = builder.user;
    }

    @Override
    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    @Nonnull
    public Optional<Integer> getExpiryDays() {
        return Optional.ofNullable(this.expiryDays);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.tokenId;
    }

    @Override
    @Nonnull
    public Optional<Date> getLastAuthenticated() {
        return Optional.ofNullable(this.lastAuthenticated);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public String toString() {
        return "AbstractAccessToken{createdDate=" + String.valueOf(this.createdDate) + ", expiryDays=" + this.expiryDays + ", lastAuthenticated=" + String.valueOf(this.lastAuthenticated) + ", name='" + this.name + "', permissions=" + String.valueOf(this.permissions) + ", tokenId='" + this.tokenId + "', user=" + String.valueOf(this.user) + "}";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private final ImmutableSet.Builder<Permission> permissions = ImmutableSet.builder();
        private final String tokenId;
        private Date createdDate;
        private Integer expiryDays;
        private Date lastAuthenticated;
        private String name;
        private ApplicationUser user;

        protected AbstractBuilder(@Nonnull String tokenId) {
            this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
        }

        protected AbstractBuilder(@Nonnull AoAccessToken aoAccessToken, @Nonnull ApplicationUser user) {
            this(aoAccessToken, user, null);
        }

        protected AbstractBuilder(@Nonnull AoAccessToken aoAccessToken, @Nonnull ApplicationUser user, @Nullable Integer effectiveExpiryDays) {
            this.user = Objects.requireNonNull(user, "user");
            Objects.requireNonNull(aoAccessToken, "aoAccessToken");
            this.tokenId = aoAccessToken.getID();
            this.lastAuthenticated = aoAccessToken.getLastAuthenticated();
            this.createdDate = aoAccessToken.getCreatedDate();
            this.expiryDays = effectiveExpiryDays;
            this.name = aoAccessToken.getName();
            this.permissions.addAll((Iterable)Arrays.stream(aoAccessToken.getAccessTokenPermissions()).map(aoAccessTokenPermission -> Permission.fromId((int)aoAccessTokenPermission.getPermissionId())).collect(Collectors.toSet()));
        }

        protected AbstractBuilder(@Nonnull AccessToken accessToken) {
            this.tokenId = accessToken.getId();
            this.lastAuthenticated = accessToken.getLastAuthenticated().orElse(null);
            this.createdDate = accessToken.getCreatedDate();
            this.expiryDays = accessToken.getExpiryDays().orElse(null);
            this.name = accessToken.getName();
            this.permissions.addAll(accessToken.getPermissions());
            this.user = accessToken.getUser();
        }

        @Nonnull
        public B createdDate(@Nonnull Date createdDate) {
            this.createdDate = Objects.requireNonNull(createdDate, "createdDate");
            return this.self();
        }

        @Nonnull
        public B expiryDays(@Nullable Integer expiryDays) {
            this.expiryDays = expiryDays;
            return this.self();
        }

        @Nonnull
        public B lastAuthenticated(@Nullable Date lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this.self();
        }

        @Nonnull
        public B permission(@Nonnull Permission permission) {
            this.permissions.add((Object)Objects.requireNonNull(permission, "permission"));
            return this.self();
        }

        @Nonnull
        public B permissions(@Nonnull Set<Permission> permissions) {
            this.permissions.addAll((Iterable)Objects.requireNonNull(permissions, "permissions"));
            return this.self();
        }

        @Nonnull
        public B user(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user);
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

