/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessToken;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Named;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenAdminUserContextProvider
implements ContextProvider {
    private final AccessTokenSettingsService settingsService;
    private final AccessTokenService<ApplicationUser> userAccessTokenService;
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final UserService userService;

    @Autowired
    public AccessTokenAdminUserContextProvider(AccessTokenSettingsService settingsService, @Named(value="userAccessTokenService") AccessTokenService<ApplicationUser> userAccessTokenService, AuthenticationContext authenticationContext, I18nService i18nService, PermissionService permissionService, UserService userService) {
        this.userAccessTokenService = userAccessTokenService;
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.settingsService = settingsService;
        this.userService = userService;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.convertToApplicationUser((Person)context.get("user"));
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.settingsService.getMaxTokensPerUser());
        Page<AccessToken> accessTokens = this.userAccessTokenService.search(new AccessTokenSearchRequest.Builder<ApplicationUser>(user).build(), pageRequest);
        return ImmutableMap.builder().put((Object)"accessTokens", (Object)new RestPage(accessTokens, RestAccessToken::new)).put((Object)"user", (Object)user).put((Object)"isUserEditPage", (Object)true).put((Object)"maxTokensPerUser", (Object)this.settingsService.getMaxTokensPerUser()).put((Object)"canEdit", (Object)this.canEdit(user)).build();
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    private boolean canEdit(ApplicationUser user) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && (currentUser.getId() == user.getId() || this.permissionService.hasGlobalPermission(Permission.ADMIN) && !this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN));
    }

    private ApplicationUser convertToApplicationUser(Person user) {
        ApplicationUser applicationUser;
        String username = user.getName();
        ApplicationUser applicationUser2 = applicationUser = user instanceof ApplicationUser ? (ApplicationUser)user : this.userService.getUserByName(username);
        if (applicationUser == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.web.access.tokens.error.nosuchuser", new Object[]{username}), username);
        }
        return applicationUser;
    }
}

