/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenCreateRequest<T> {
    private final T entity;
    private final Integer expiryDays;
    private final String name;
    private final Set<Permission> permissions;

    protected AccessTokenCreateRequest(Builder<T> builder) {
        this.entity = builder.entity;
        this.expiryDays = builder.expiryDays;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.permissions = builder.permissionBuilder.build();
    }

    @Nonnull
    public T getEntity() {
        return this.entity;
    }

    @Nonnull
    public Optional<Integer> getExpiryDays() {
        return Optional.ofNullable(this.expiryDays);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public static class Builder<T>
    extends BuilderSupport {
        public final T entity;
        private final ImmutableSet.Builder<Permission> permissionBuilder = ImmutableSet.builder();
        private Integer expiryDays;
        private String name;

        public Builder(@Nonnull T entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
        }

        @Nonnull
        public AccessTokenCreateRequest<T> build() {
            return new AccessTokenCreateRequest(this);
        }

        @Nonnull
        public Builder<T> expiryDays(@Nullable Integer value) {
            this.expiryDays = value;
            return this;
        }

        @Nonnull
        public Builder<T> name(@Nonnull String value) {
            this.name = Objects.requireNonNull(StringUtils.stripToNull((String)value), "name");
            return this;
        }

        @Nonnull
        public Builder<T> permissions(@Nonnull Set<Permission> value) {
            this.permissionBuilder.addAll((Iterable)Objects.requireNonNull(value, "permissions"));
            return this;
        }

        @Nonnull
        public Builder<T> permissions(Permission ... value) {
            this.permissionBuilder.addAll(Arrays.asList(Objects.requireNonNull(value, "permissions")));
            return this;
        }
    }
}

