/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AuthenticateAccessTokenRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.security.random.SecureRandomService;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenGenerator {
    public static final String TOKEN_PREFIX = "BBDC-";
    private static final char DELIMITER = ':';
    private static final int ID_LENGTH = 12;
    private static final int SECRET_LENGTH = 20;
    private static final int DECODED_TOKEN_LENGTH = 33;
    private static final int ENCODED_TOKEN_LENGTH = 44;
    private final I18nService i18nService;
    private final PasswordEncoder passwordEncoder;
    private final SecureRandomService secureRandomService;

    @Autowired
    public AccessTokenGenerator(PasswordEncoder passwordEncoder, SecureRandomService secureRandomService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.passwordEncoder = passwordEncoder;
        this.secureRandomService = secureRandomService;
    }

    public boolean authenticateToken(@Nonnull String token, @Nonnull String hashedToken) {
        String secret;
        try {
            secret = this.getSecret(token);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
        return this.passwordEncoder.isValidPassword(secret, hashedToken);
    }

    @Nonnull
    public String generateToken() {
        byte[] tokenBytes = new byte[33];
        byte[] id = this.generateId();
        System.arraycopy(id, 0, tokenBytes, 0, id.length);
        tokenBytes[id.length] = 58;
        byte[] secret = this.generateSecret();
        System.arraycopy(secret, 0, tokenBytes, id.length + 1, secret.length);
        return Base64.encodeBase64String((byte[])tokenBytes);
    }

    @Nonnull
    public String getId(@Nonnull String token) throws ArgumentValidationException {
        if (!this.isValidToken(token)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.invalidtoken", new Object[0]));
        }
        return new String(Arrays.copyOfRange(Base64.decodeBase64((String)token), 0, 12), StandardCharsets.UTF_8);
    }

    public String getToken(AuthenticateAccessTokenRequest request) {
        String token = request.getToken();
        if (token.length() == 44 + TOKEN_PREFIX.length() && token.startsWith(TOKEN_PREFIX)) {
            token = token.substring(TOKEN_PREFIX.length());
        }
        return token;
    }

    @Nonnull
    public String hashToken(@Nonnull String token) {
        if (!this.isValidToken(token)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.invalidtoken", new Object[0]));
        }
        String secret = this.getSecret(token);
        return this.passwordEncoder.encodePassword(secret);
    }

    public boolean isValidToken(@Nonnull String token) {
        Objects.requireNonNull(token, "token");
        if (token.length() == 44 && Base64.isBase64((String)token)) {
            byte[] decodedToken;
            try {
                decodedToken = Base64.decodeBase64((String)token);
            }
            catch (IllegalArgumentException ignored) {
                return false;
            }
            return decodedToken.length == 33 && decodedToken[12] == 58;
        }
        return false;
    }

    private byte[] generateId() {
        StringBuilder idBuilder = new StringBuilder(12);
        for (int i = 0; i < 12; ++i) {
            idBuilder.append(this.secureRandomService.nextInt(10));
        }
        return idBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] generateSecret() {
        byte[] secret = new byte[20];
        this.secureRandomService.nextBytes(secret);
        return secret;
    }

    private String getSecret(@Nonnull String token) {
        byte[] decodedToken = Base64.decodeBase64((String)token);
        byte[] secret = Arrays.copyOfRange(decodedToken, 13, decodedToken.length);
        return Base64.encodeBase64String((byte[])secret);
    }
}

