/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.permission.Permission;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenUpdateRequest {
    private final String name;
    private final Set<Permission> permissions;
    private final String tokenId;

    private AccessTokenUpdateRequest(Builder builder) {
        this.tokenId = builder.tokenId;
        this.name = builder.name;
        this.permissions = builder.permissions.build();
    }

    @Nonnull
    public static Builder builder(@Nonnull String tokenId) {
        return new Builder(tokenId);
    }

    @Nonnull
    public String getId() {
        return this.tokenId;
    }

    @Nonnull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public static class Builder {
        private final ImmutableSet.Builder<Permission> permissions = ImmutableSet.builder();
        private final String tokenId;
        private String name;

        public Builder(@Nonnull String tokenId) {
            this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
        }

        @Nonnull
        public AccessTokenUpdateRequest build() {
            return new AccessTokenUpdateRequest(this);
        }

        @Nonnull
        public Builder name(@Nullable String name) {
            if (!StringUtils.isBlank((CharSequence)name)) {
                this.name = name;
            }
            return this;
        }

        @Nonnull
        public Builder permissions(@Nonnull Set<Permission> permissions) {
            this.permissions.addAll((Iterable)Objects.requireNonNull(permissions, "permissions"));
            return this;
        }
    }
}

