/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class AuthenticateAccessTokenRequest {
    private final String token;
    private final ApplicationUser user;

    private AuthenticateAccessTokenRequest(Builder builder) {
        this.token = builder.token;
        this.user = builder.user;
    }

    @Nonnull
    public static Builder builder(@Nonnull String token) {
        return new Builder(token);
    }

    @Nonnull
    public String getToken() {
        return this.token;
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public static class Builder {
        private final String token;
        private ApplicationUser user;

        public Builder(@Nonnull String token) {
            this.token = Objects.requireNonNull(token, "token");
        }

        @Nonnull
        public AuthenticateAccessTokenRequest build() {
            return new AuthenticateAccessTokenRequest(this);
        }

        @Nonnull
        public Builder user(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, "user");
            return this;
        }
    }
}

