/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.DateProvider;
import com.atlassian.bitbucket.internal.accesstokens.event.AccessTokenMaxExpiryChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultAccessTokenSettingsService
implements AccessTokenSettingsService {
    static final String ACCESS_TOKENS_KEY = "com.atlassian.bitbucket.server.bitbucket-access-tokens";
    static final int DEFAULT_MAX_TOKENS_PER_USER = 100;
    static final String MAX_EXPIRY = "maxExpiryDays";
    static final String MAX_TOKENS_PER_USER_PROPERTY_KEY = "plugin.bitbucket-access-tokens.max.tokens.per.user";
    private final DateProvider dateProvider;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final int maxTokensPerUser;
    private final PermissionValidationService permissionValidationService;
    private final PluginSettings pluginSettings;

    public DefaultAccessTokenSettingsService(ApplicationPropertiesService applicationPropertiesService, DateProvider dateProvider, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PluginSettingsFactory pluginSettingsFactory) {
        this.dateProvider = dateProvider;
        this.permissionValidationService = permissionValidationService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.maxTokensPerUser = applicationPropertiesService.getPluginProperty(MAX_TOKENS_PER_USER_PROPERTY_KEY, 100);
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(ACCESS_TOKENS_KEY);
    }

    @Override
    @Nonnull
    public Optional<Integer> getMaxExpiry() {
        return Optional.ofNullable(this.getMaxExpiryDaysInternal());
    }

    @Override
    public void setMaxExpiry(int days) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (days <= 0) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.access.tokens.error.admin.expiry", new Object[0]));
        }
        Integer previousExpiry = this.getMaxExpiry().orElse(null);
        if (!Integer.valueOf(days).equals(previousExpiry)) {
            this.pluginSettings.put(MAX_EXPIRY, (Object)String.valueOf(days));
            this.eventPublisher.publish((Object)new AccessTokenMaxExpiryChangedEvent(this, previousExpiry, days));
        }
    }

    @Override
    public int getMaxTokensPerUser() {
        return this.maxTokensPerUser;
    }

    @Override
    public boolean hasExpired(AccessToken token) {
        Integer effectiveExpiryDays = Arrays.stream(new Integer[]{token.getExpiryDays().orElse(null), this.getMaxExpiryDaysInternal()}).filter(Objects::nonNull).min(Comparator.comparingInt(days -> days)).orElse(null);
        return effectiveExpiryDays != null && DateUtils.addDays((Date)token.getCreatedDate(), (int)effectiveExpiryDays).before(this.dateProvider.getDate());
    }

    @Override
    public void removeMaxExpiry() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.getMaxExpiry().ifPresent(previousExpiry -> {
            this.pluginSettings.remove(MAX_EXPIRY);
            this.eventPublisher.publish((Object)new AccessTokenMaxExpiryChangedEvent(this, (Integer)previousExpiry, null));
        });
    }

    @Nullable
    private Integer getMaxExpiryDaysInternal() {
        String expiryDaysString = (String)this.pluginSettings.get(MAX_EXPIRY);
        if (expiryDaysString == null) {
            return null;
        }
        return Integer.valueOf(expiryDaysString);
    }
}

