/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenCreateRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenExpiryHelper;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenGenerator;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.DateProvider;
import com.atlassian.bitbucket.internal.accesstokens.HashedAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.InternalAccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.RawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.SimpleAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.SimpleHashedAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.SimpleRawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AccessTokenDao;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.exception.CreateTokenFailedException;
import com.atlassian.bitbucket.internal.accesstokens.exception.TokenLimitExceededException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="internalAccessTokenService")
public class DefaultInternalAccessTokenService
implements InternalAccessTokenService {
    private static final int MAX_CREATE_RETRIES = 10;
    private static final Set<Permission> allowablePermission = ImmutableSet.of((Object)Permission.PROJECT_ADMIN, (Object)Permission.PROJECT_WRITE, (Object)Permission.PROJECT_READ, (Object)Permission.REPO_ADMIN, (Object)Permission.REPO_WRITE, (Object)Permission.REPO_READ, (Object[])new Permission[0]);
    private final AccessTokenDao accessTokenDao;
    private final AccessTokenGenerator accessTokenGenerator;
    private final AccessTokenSettingsService accessTokensSettingsService;
    private final DateProvider dateProvider;
    private final I18nService i18nService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    DefaultInternalAccessTokenService(AccessTokenDao accessTokenDao, AccessTokenGenerator accessTokenGenerator, AccessTokenSettingsService accessTokenSettingsService, DateProvider dateProvider, I18nService i18nService, TransactionTemplate transactionTemplate, UserService userService) {
        this.accessTokenDao = accessTokenDao;
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokensSettingsService = accessTokenSettingsService;
        this.dateProvider = dateProvider;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public RawAccessToken create(@Nonnull AccessTokenCreateRequest<ApplicationUser> request) {
        Objects.requireNonNull(request, "request");
        this.validateAllowablePermissions(request.getPermissions());
        ApplicationUser user = request.getEntity();
        Integer maxExpiryDays = this.getMaxExpiryDays();
        Date createdDate = this.dateProvider.getDate();
        if (!(maxExpiryDays == null || request.getExpiryDays().isPresent() && request.getExpiryDays().get() <= maxExpiryDays)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.create.expiry.toolarge", new Object[]{maxExpiryDays}));
        }
        return (RawAccessToken)this.transactionTemplate.execute(() -> {
            int maxTokensPerUser = this.accessTokensSettingsService.getMaxTokensPerUser();
            if (this.accessTokenDao.countForUser(user) >= maxTokensPerUser) {
                throw new TokenLimitExceededException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.too.many", new Object[]{maxTokensPerUser}));
            }
            for (int attempts = 0; attempts < 10; ++attempts) {
                String token = this.accessTokenGenerator.generateToken();
                String tokenId = this.accessTokenGenerator.getId(token);
                if (this.accessTokenDao.getById(tokenId).isPresent()) continue;
                String hashedToken = this.accessTokenGenerator.hashToken(token);
                HashedAccessToken hashedAccessToken = ((SimpleHashedAccessToken.Builder)((SimpleHashedAccessToken.Builder)((SimpleHashedAccessToken.Builder)((SimpleHashedAccessToken.Builder)new SimpleHashedAccessToken.Builder(tokenId, hashedToken).createdDate(createdDate)).name(request.getName())).permissions(request.getPermissions())).user(user)).build();
                AoAccessToken aoAccessToken = this.accessTokenDao.create(hashedAccessToken, request.getExpiryDays().orElse(null));
                return new SimpleRawAccessToken.Builder(aoAccessToken, user, this.getEffectiveExpiryDays(aoAccessToken), "BBDC-" + token).build();
            }
            throw new CreateTokenFailedException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.create", new Object[0]));
        });
    }

    @Override
    public void delete(@Nonnull AccessToken accessToken) {
        Objects.requireNonNull(accessToken, "accessToken");
        this.transactionTemplate.execute(() -> {
            AoAccessToken aoAccessToken = this.accessTokenDao.getById(accessToken.getId()).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.notfound", new Object[0])));
            this.accessTokenDao.delete(aoAccessToken);
            return null;
        });
    }

    @Override
    @Nonnull
    public Optional<AccessToken> getById(@Nonnull String tokenId) {
        Objects.requireNonNull(tokenId, "tokenId");
        return (Optional)this.transactionTemplate.execute(() -> this.accessTokenDao.getById(tokenId).flatMap(token -> {
            ApplicationUser tokenUser = this.userService.getUserById(token.getUserId());
            if (tokenUser == null) {
                return Optional.empty();
            }
            Integer effectiveExpiryDays = this.getEffectiveExpiryDays((AoAccessToken)token);
            return Optional.of(new SimpleAccessToken.Builder((AoAccessToken)token, tokenUser, effectiveExpiryDays).build());
        }));
    }

    @Override
    @Nonnull
    public Page<AccessToken> search(@Nonnull AccessTokenSearchRequest<ApplicationUser> request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        ApplicationUser user = request.getEntity();
        return (Page)this.transactionTemplate.execute(() -> this.accessTokenDao.searchByUser(user, pageRequest).transform(aoAccessToken -> new SimpleAccessToken.Builder((AoAccessToken)aoAccessToken, user, this.getEffectiveExpiryDays((AoAccessToken)aoAccessToken)).build()));
    }

    @Override
    @Nonnull
    public AccessToken update(@Nonnull AccessToken token, @Nullable String name, @Nonnull Set<Permission> permissions) {
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(permissions, "permissions");
        this.validateAllowablePermissions(permissions);
        return (AccessToken)this.transactionTemplate.execute(() -> {
            AoAccessToken aoAccessToken = this.accessTokenDao.getById(token.getId()).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.notfound", new Object[]{token.getId()})));
            Integer effectiveExpiryDays = this.getEffectiveExpiryDays(aoAccessToken);
            aoAccessToken = this.accessTokenDao.update(aoAccessToken, name, permissions);
            return new SimpleAccessToken.Builder(aoAccessToken, token.getUser(), effectiveExpiryDays).build();
        });
    }

    protected Integer getEffectiveExpiryDays(AoAccessToken aoAccessToken) {
        return AccessTokenExpiryHelper.getEffectiveExpiryDays(aoAccessToken.getExpiryDays(), this.getMaxExpiryDays());
    }

    protected Integer getMaxExpiryDays() {
        return this.accessTokensSettingsService.getMaxExpiry().orElse(null);
    }

    protected void validateAllowablePermissions(@Nonnull Set<Permission> permissions) {
        Sets.SetView disallowedPermissions = Sets.difference(permissions, allowablePermission);
        if (!disallowedPermissions.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.bad.permissions", new Object[]{disallowedPermissions.size(), StringUtils.join((Iterable)disallowedPermissions, (String)", ")}));
        }
    }
}

