/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenCreateRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenUpdateRequest;
import com.atlassian.bitbucket.internal.accesstokens.InternalAccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.RawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenCreatedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenDeletedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenModifiedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scopeAccessTokenService")
public class DefaultScopeAccessTokenService
implements AccessTokenService<Scope> {
    private static final String ACCESS_TOKEN_USER_PREFIX = "access-token-user";
    private static final Set<Permission> ALLOWED_PROJECT_PERMISSIONS = ImmutableSet.of((Object)Permission.PROJECT_ADMIN, (Object)Permission.PROJECT_WRITE, (Object)Permission.PROJECT_READ, (Object)Permission.REPO_ADMIN, (Object)Permission.REPO_WRITE, (Object)Permission.REPO_READ, (Object[])new Permission[0]);
    private static final Set<Permission> ALLOWED_REPO_PERMISSIONS = ImmutableSet.of((Object)Permission.REPO_ADMIN, (Object)Permission.REPO_WRITE, (Object)Permission.REPO_READ);
    private static final String SERVICE_USER_DISPLAY_NAME_FORMAT_PROJECT = "Access Token User - %s";
    private static final String SERVICE_USER_DISPLAY_NAME_FORMAT_REPO = "Access Token User - %s %s";
    private static final String SERVICE_USER_LABEL = "access-token";
    private static final Logger log = LoggerFactory.getLogger(DefaultScopeAccessTokenService.class);
    private static final String USERNAME_PARTS_SEPARATOR = "/";
    private static final String SERVICE_USER_NAME_FORMAT = "access-token-user/%s/%s";
    private final AuthenticationContext authenticationContext;
    private final InternalAccessTokenService delegate;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionAdminService permissionAdminService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;
    private final UserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    DefaultScopeAccessTokenService(AuthenticationContext authenticationContext, InternalAccessTokenService delegate, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, PermissionAdminService permissionAdminService, ProjectSettingsRestrictionService projectSettingsRestrictionService, RepositoryService repositoryService, ProjectService projectService, TransactionTemplate transactionTemplate, UserAdminService userAdminService, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.permissionAdminService = permissionAdminService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.transactionTemplate = transactionTemplate;
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public RawAccessToken create(@Nonnull AccessTokenCreateRequest<Scope> request) {
        this.featureManager.requireEnabled((Feature)StandardFeature.PROJECT_REPO_ACCESS_TOKENS);
        Scope scope = Objects.requireNonNull(request, "request").getEntity();
        return (RawAccessToken)this.transactionTemplate.execute(() -> {
            this.validateScope(scope);
            this.validateAdminPermission(scope);
            this.validateAllowedPermissions(scope, request.getPermissions());
            this.validateCurrentUserIsNotToken();
            this.validateIsNotRestricted(scope, "bitbucket.settingsrestriction.access.restrictionexists.create");
            ApplicationUser user = this.getOrCreateServiceUser((Scope)request.getEntity());
            AccessTokenCreateRequest<ApplicationUser> userRequest = new AccessTokenCreateRequest.Builder<ApplicationUser>(user).expiryDays(request.getExpiryDays().orElse(null)).name(request.getName()).permissions(request.getPermissions()).build();
            RawAccessToken created = this.delegate.create(userRequest);
            this.eventPublisher.publish((Object)new ScopeAccessTokenCreatedEvent(this, scope, created.toAccessToken()));
            return created;
        });
    }

    @Override
    @Nonnull
    public Optional<AccessToken> deleteById(@Nonnull String tokenId) {
        Objects.requireNonNull(tokenId, "tokenId");
        return (Optional)this.transactionTemplate.execute(() -> this.delegate.getById(tokenId).map(token -> {
            Scope scope = this.getScopeByToken((AccessToken)token);
            this.validateAdminPermission(scope);
            this.validateCurrentUserIsNotToken();
            this.validateIsNotRestricted(scope, "bitbucket.settingsrestriction.access.restrictionexists.delete");
            this.delegate.delete((AccessToken)token);
            this.eventPublisher.publish((Object)new ScopeAccessTokenDeletedEvent(this, scope, (AccessToken)token));
            return token;
        }));
    }

    @Override
    @Nonnull
    public Optional<AccessToken> getById(@Nonnull String tokenId) {
        return this.delegate.getById(tokenId).map(token -> {
            this.validateAdminPermission(this.getScopeByToken((AccessToken)token));
            return token;
        });
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        this.unauthenticatedDelete((Scope)Scopes.project((Project)event.getProject()));
    }

    @EventListener
    public void onRepositoryDeletedEvent(RepositoryDeletedEvent event) {
        this.unauthenticatedDelete((Scope)Scopes.repository((Repository)event.getRepository()));
    }

    @Override
    @Nonnull
    public Page<AccessToken> search(@Nonnull AccessTokenSearchRequest<Scope> request, @Nonnull PageRequest pageRequest) {
        Scope scope = Objects.requireNonNull(request, "request").getEntity();
        this.validateAdminPermission(scope);
        this.validateScope(scope);
        ServiceUser serviceUser = this.getServiceUser(request.getEntity());
        if (serviceUser == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        AccessTokenSearchRequest<ServiceUser> userRequest = new AccessTokenSearchRequest.Builder<ServiceUser>(serviceUser).build();
        return this.delegate.search(userRequest, pageRequest);
    }

    @Override
    @Nonnull
    public AccessToken update(@Nonnull AccessTokenUpdateRequest request) {
        this.featureManager.requireEnabled((Feature)StandardFeature.PROJECT_REPO_ACCESS_TOKENS);
        return (AccessToken)this.transactionTemplate.execute(() -> {
            AccessToken oldToken = this.getById(request.getId()).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.notfound", new Object[]{request.getId()})));
            Scope scope = this.getScopeByToken(oldToken);
            this.validateScope(scope);
            this.validateAdminPermission(scope);
            this.validateCurrentUserIsNotToken();
            this.validateAllowedPermissions(scope, request.getPermissions());
            this.validateIsNotRestricted(scope, "bitbucket.settingsrestriction.access.restrictionexists.update");
            AccessToken updatedToken = this.delegate.update(oldToken, request.getName().orElse(null), request.getPermissions());
            this.eventPublisher.publish((Object)new ScopeAccessTokenModifiedEvent(this, scope, updatedToken, oldToken));
            return updatedToken;
        });
    }

    private ApplicationUser getOrCreateServiceUser(Scope scope) {
        String username = this.getUsernameFromScope(scope);
        ServiceUser existing = this.getServiceUser(username);
        if (existing != null) {
            if (!this.hasResourceAdminPermission(scope, (ApplicationUser)existing)) {
                this.grantResourceAdminPermission(scope, existing);
            }
            return existing;
        }
        ServiceUser serviceUser = this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(true)).displayName(this.getServiceUserDisplayName(scope))).name(username)).label(SERVICE_USER_LABEL)).build());
        this.grantResourceAdminPermission(scope, serviceUser);
        return serviceUser;
    }

    private Scope getScopeByToken(AccessToken accessToken) {
        if (accessToken.getUser().getType() == UserType.SERVICE) {
            return this.getScopeFromUsername(accessToken.getUser().getName()).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scope.access.tokens.tokenId.invalid", new Object[0])));
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scope.access.tokens.tokenId.notscope", new Object[0]));
    }

    private Optional<Scope> getScopeFromUsername(String username) {
        int resourceId;
        ScopeType scopeType;
        int scopeTypeId;
        String[] parts = username.split(USERNAME_PARTS_SEPARATOR);
        if (parts.length != 3) {
            log.trace("Provided username, {}, does not match access token username pattern (must contain 2 ':')", (Object)username);
            return Optional.empty();
        }
        if (!ACCESS_TOKEN_USER_PREFIX.equals(parts[0])) {
            log.trace("Provided username, {}, does not match access token username pattern (must start with {}:')", (Object)username, (Object)ACCESS_TOKEN_USER_PREFIX);
            return Optional.empty();
        }
        String scopeTypeIdString = parts[1];
        if (StringUtils.isBlank((CharSequence)scopeTypeIdString)) {
            log.trace("Provided username, {}, does not contain a scope type.", (Object)username);
            return Optional.empty();
        }
        try {
            scopeTypeId = Integer.parseInt(scopeTypeIdString);
        }
        catch (NumberFormatException e) {
            log.trace("Provided scope type, {}, is not an integer.", (Object)scopeTypeIdString);
            return Optional.empty();
        }
        try {
            scopeType = ScopeType.fromId((int)scopeTypeId);
        }
        catch (IllegalArgumentException e) {
            log.trace("Provided scope type, {}, is not a known scope type.", (Object)scopeTypeIdString);
            return Optional.empty();
        }
        String resourceIdString = parts[2];
        if (StringUtils.isBlank((CharSequence)resourceIdString)) {
            log.trace("Provided username, {}, does not contain a resource ID.", (Object)username);
            return Optional.empty();
        }
        try {
            resourceId = Integer.parseInt(resourceIdString);
        }
        catch (NumberFormatException e) {
            log.trace("Provided resource ID, {}, is not an integer.", (Object)resourceIdString);
            return Optional.empty();
        }
        switch (scopeType) {
            case PROJECT: {
                return Optional.ofNullable(this.projectService.getById(resourceId)).map(Scopes::project);
            }
            case REPOSITORY: {
                return Optional.ofNullable(this.repositoryService.getById(resourceId)).map(Scopes::repository);
            }
        }
        log.trace("Provided scope type, {}, is not supported.", (Object)scopeType.name());
        return Optional.empty();
    }

    private ServiceUser getServiceUser(Scope scope) {
        return this.getServiceUser(this.getUsernameFromScope(scope));
    }

    private ServiceUser getServiceUser(String username) {
        return this.userService.getServiceUserByName(username);
    }

    private String getServiceUserDisplayName(Scope scope) {
        return (String)scope.accept((ScopeVisitor)new ScopeVisitor<String>(this){

            public String visit(@Nonnull ProjectScope scope) {
                return String.format(DefaultScopeAccessTokenService.SERVICE_USER_DISPLAY_NAME_FORMAT_PROJECT, scope.getProject().getName());
            }

            public String visit(@Nonnull RepositoryScope scope) {
                return String.format(DefaultScopeAccessTokenService.SERVICE_USER_DISPLAY_NAME_FORMAT_REPO, scope.getProject().getName(), scope.getRepository().getName());
            }
        });
    }

    private String getUsernameFromScope(Scope scope) {
        return String.format(SERVICE_USER_NAME_FORMAT, scope.getType().getId(), scope.getResourceId().map(String::valueOf).orElse(""));
    }

    private void grantResourceAdminPermission(Scope scope, ServiceUser serviceUser) {
        final SetPermissionRequest.Builder permissionRequest = new SetPermissionRequest.Builder().user((ApplicationUser)serviceUser);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                permissionRequest.projectPermission(Permission.PROJECT_ADMIN, scope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                permissionRequest.repositoryPermission(Permission.REPO_ADMIN, scope.getRepository());
                return null;
            }
        });
        this.permissionAdminService.setPermission(permissionRequest.build());
    }

    private boolean hasResourceAdminPermission(Scope scope, final ApplicationUser user) {
        return (Boolean)scope.accept((ScopeVisitor)new ScopeVisitor<Boolean>(){

            public Boolean visit(@Nonnull GlobalScope scope) {
                return true;
            }

            public Boolean visit(@Nonnull ProjectScope scope) {
                return DefaultScopeAccessTokenService.this.permissionService.hasProjectPermission(user, scope.getProject(), Permission.PROJECT_ADMIN);
            }

            public Boolean visit(@Nonnull RepositoryScope scope) {
                return DefaultScopeAccessTokenService.this.permissionService.hasRepositoryPermission(user, scope.getRepository(), Permission.REPO_ADMIN);
            }
        });
    }

    private void unauthenticatedDelete(Scope scope) {
        this.transactionTemplate.execute(() -> {
            ServiceUser serviceUser = this.getServiceUser(scope);
            if (serviceUser == null) {
                return null;
            }
            AccessTokenSearchRequest<ServiceUser> userRequest = new AccessTokenSearchRequest.Builder<ServiceUser>(serviceUser).build();
            PageUtils.toStream(pageRequest -> this.delegate.search(userRequest, pageRequest), (int)100).forEach(token -> {
                this.delegate.delete((AccessToken)token);
                this.eventPublisher.publish((Object)new ScopeAccessTokenDeletedEvent(this, scope, (AccessToken)token));
            });
            return null;
        });
    }

    private void validateAdminPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultScopeAccessTokenService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultScopeAccessTokenService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateCurrentUserIsNotToken() {
        if (this.authenticationContext.getProperties().containsKey("bbs.security.token.id")) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.scope.access.tokens.token.forbidden", new Object[0]));
        }
    }

    private void validateAllowedPermissions(Scope scope, final Set<Permission> permissions) {
        Boolean validPermissions = (Boolean)scope.accept((ScopeVisitor)new ScopeVisitor<Boolean>(){

            public Boolean visit(@Nonnull ProjectScope scope) {
                return ALLOWED_PROJECT_PERMISSIONS.containsAll(permissions);
            }

            public Boolean visit(@Nonnull RepositoryScope scope) {
                return ALLOWED_REPO_PERMISSIONS.containsAll(permissions);
            }
        });
        if (!validPermissions.booleanValue()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scope.access.tokens.permissions.invalid", new Object[]{scope.getType().name(), permissions.stream().map(Enum::name).collect(Collectors.joining(", "))}));
        }
    }

    private void validateScope(Scope scope) {
        if (scope.getType() == ScopeType.GLOBAL) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scope.access.tokens.scope.invalid", new Object[0]));
        }
    }

    private void validateIsNotRestricted(Scope scope, final String errorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                if (DefaultScopeAccessTokenService.this.permissionService.hasProjectPermission(scope.getProject(), Permission.PROJECT_ADMIN)) {
                    return null;
                }
                DefaultScopeAccessTokenService.this.projectSettingsRestrictionService.get(scope.getProject(), ProjectSettingsRestrictionKeys.ACCESS_TOKENS).ifPresent(restriction -> {
                    throw new ForbiddenException(DefaultScopeAccessTokenService.this.i18nService.createKeyedMessage(errorKey, new Object[0]));
                });
                return null;
            }
        });
    }
}

