/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenCreateRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenUpdateRequest;
import com.atlassian.bitbucket.internal.accesstokens.InternalAccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.RawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenCreatedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenDeletedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenModifiedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userAccessTokenService")
public class DefaultUserAccessTokenService
implements AccessTokenService<ApplicationUser> {
    private final AuthenticationContext authenticationContext;
    private final InternalAccessTokenService delegate;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    DefaultUserAccessTokenService(AuthenticationContext authenticationContext, InternalAccessTokenService delegate, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nonnull
    public RawAccessToken create(@Nonnull AccessTokenCreateRequest<ApplicationUser> request) {
        ApplicationUser user = Objects.requireNonNull(request, "request").getEntity();
        return (RawAccessToken)this.transactionTemplate.execute(() -> {
            this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
            if (!user.equals((Object)this.authenticationContext.getCurrentUser())) {
                throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.create.unauthorized", new Object[0]));
            }
            RawAccessToken created = this.delegate.create(request);
            this.eventPublisher.publish((Object)new PersonalAccessTokenCreatedEvent(this, created.toAccessToken()));
            return created;
        });
    }

    @Override
    @Nonnull
    public Optional<AccessToken> deleteById(@Nonnull String tokenId) {
        Objects.requireNonNull(tokenId, "tokenId");
        this.permissionValidationService.validateAuthenticated();
        return (Optional)this.transactionTemplate.execute(() -> this.delegate.getById(tokenId).map(existing -> {
            this.permissionValidationService.validateForUser(existing.getUser(), Permission.USER_ADMIN);
            this.delegate.delete((AccessToken)existing);
            this.eventPublisher.publish((Object)new PersonalAccessTokenDeletedEvent(this, (AccessToken)existing));
            return existing;
        }));
    }

    @Override
    @Nonnull
    public Optional<AccessToken> getById(@Nonnull String tokenId) {
        Objects.requireNonNull(tokenId, "tokenId");
        this.permissionValidationService.validateAuthenticated();
        return this.delegate.getById(tokenId).map(token -> {
            if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
                this.permissionValidationService.validateForUser(token.getUser(), Permission.USER_ADMIN);
            }
            return token;
        });
    }

    @EventListener
    public void onUserDeleted(@Nonnull UserCleanupEvent userCleanupEvent) {
        ApplicationUser user = userCleanupEvent.getDeletedUser();
        this.transactionTemplate.execute(() -> {
            PageUtils.toStream(pageRequest -> this.delegate.search(new AccessTokenSearchRequest.Builder<ApplicationUser>(user).build(), pageRequest), (int)100).forEach(token -> {
                this.delegate.delete((AccessToken)token);
                this.eventPublisher.publish((Object)new PersonalAccessTokenDeletedEvent(this, (AccessToken)token));
            });
            return null;
        });
    }

    @Override
    @Nonnull
    public Page<AccessToken> search(@Nonnull AccessTokenSearchRequest<ApplicationUser> request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        ApplicationUser user = request.getEntity();
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
        }
        return this.delegate.search(request, pageRequest);
    }

    @Override
    @Nonnull
    public AccessToken update(@Nonnull AccessTokenUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateAuthenticated();
        return (AccessToken)this.transactionTemplate.execute(() -> {
            AccessToken oldToken = this.delegate.getById(request.getId()).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.notfound", new Object[]{request.getId()})));
            this.permissionValidationService.validateForUser(oldToken.getUser(), Permission.USER_ADMIN);
            AccessToken newToken = this.delegate.update(oldToken, request.getName().orElse(null), request.getPermissions());
            this.eventPublisher.publish((Object)new PersonalAccessTokenModifiedEvent(this, newToken, oldToken));
            return newToken;
        });
    }
}

