/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessToken;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Named;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
public class ManageAccessTokensServlet
extends HttpServlet {
    @VisibleForTesting
    static final String MANAGE_TOKENS_TEMPLATE_KEY_PREFIX = "bitbucketPluginAccessTokens.internal.feature.accessTokens.page.manageAccessTokensPage.";
    @VisibleForTesting
    static final String PROJECT_MANAGE_TOKENS_TEMPLATE_KEY = "projectPage";
    @VisibleForTesting
    static final String REPO_MANAGE_TOKENS_TEMPLATE_KEY = "repositoryPage";
    @VisibleForTesting
    static final String USER_MANAGE_TOKENS_TEMPLATE_KEY = "userPage";
    private static final String PROJECTS = "projects";
    private static final String REPOS = "repos";
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-access-tokens:server-soy-templates";
    private static final String USERS = "users";
    private final AccessTokenSettingsService accessTokenSettingsService;
    private final AuthenticationContext authenticationContext;
    private final FeatureDiscoveryService featureDiscoveryService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final RepositoryService repositoryService;
    private final AccessTokenService<Scope> scopeAccessTokenService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final AccessTokenService<ApplicationUser> userAccessTokenService;
    private final UserService userService;
    private final WebSudoManager webSudoManager;

    public ManageAccessTokensServlet(AccessTokenSettingsService accessTokenSettingsService, AuthenticationContext authenticationContext, FeatureDiscoveryService featureDiscoveryService, FeatureManager featureManager, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, ProjectService projectService, ProjectSettingsRestrictionService projectSettingsRestrictionService, RepositoryService repositoryService, @Named(value="scopeAccessTokenService") AccessTokenService<Scope> scopeAccessTokenService, SoyTemplateRenderer soyTemplateRenderer, @Named(value="userAccessTokenService") AccessTokenService<ApplicationUser> userAccessTokenService, UserService userService, WebSudoManager webSudoManager) {
        this.accessTokenSettingsService = accessTokenSettingsService;
        this.authenticationContext = authenticationContext;
        this.featureDiscoveryService = featureDiscoveryService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.repositoryService = repositoryService;
        this.scopeAccessTokenService = scopeAccessTokenService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userAccessTokenService = userAccessTokenService;
        this.userService = userService;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationUser user;
        this.permissionValidationService.validateAuthenticated();
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"maxTokensPerUser", (Object)this.accessTokenSettingsService.getMaxTokensPerUser());
        this.accessTokenSettingsService.getMaxExpiry().ifPresent(maxExpiryDays -> params.put((Object)"maxExpiryDays", maxExpiryDays));
        List<String> pathParts = ManageAccessTokensServlet.getPathParts(req);
        String template = null;
        Scope scope = this.getScope(pathParts);
        if (scope != null) {
            if (!this.featureManager.isEnabled((Feature)StandardFeature.PROJECT_REPO_ACCESS_TOKENS)) {
                resp.sendError(401, this.i18nService.getMessage("bitbucket.web.access.tokens.project.repo.feature.unavailable", new Object[0]));
                return;
            }
            this.addScopeParams((ImmutableMap.Builder<String, Object>)params, scope);
            template = ScopeType.PROJECT.equals((Object)scope.getType()) ? PROJECT_MANAGE_TOKENS_TEMPLATE_KEY : REPO_MANAGE_TOKENS_TEMPLATE_KEY;
            this.featureDiscoveryService.setDiscovered(EnumSet.of(DiscoverableFeature.PROJECT_REPO_ACCESS_TOKENS));
        }
        ApplicationUser applicationUser = user = pathParts.isEmpty() ? this.authenticationContext.getCurrentUser() : this.getUser(pathParts);
        if (user != null) {
            if (this.authenticationContext.getCurrentUser().getId() != user.getId()) {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            params.put((Object)"user", (Object)user);
            template = USER_MANAGE_TOKENS_TEMPLATE_KEY;
        }
        if (!pathParts.isEmpty() && user == null && scope == null) {
            resp.sendError(404);
            return;
        }
        Page<AccessToken> accessTokens = this.getAccessTokens(user, scope);
        this.render((ServletResponse)resp, MANAGE_TOKENS_TEMPLATE_KEY_PREFIX + template, (Map<String, Object>)params.put((Object)"accessTokens", (Object)new RestPage(accessTokens, RestAccessToken::new)).build());
    }

    private static List<String> getPathParts(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Collections.emptyList();
        }
        return Arrays.stream(pathInfo.split("/")).map(StringUtils::stripToNull).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void addScopeParams(final ImmutableMap.Builder<String, Object> params, Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                params.put((Object)"project", (Object)scope.getProject());
                ManageAccessTokensServlet.this.projectSettingsRestrictionService.get(scope.getProject(), ProjectSettingsRestrictionKeys.ACCESS_TOKENS).ifPresent(restriction -> params.put((Object)"restriction", restriction));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                Project project = scope.getProject();
                Optional restriction = ManageAccessTokensServlet.this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.ACCESS_TOKENS);
                boolean readOnly = restriction.isPresent() && !ManageAccessTokensServlet.this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
                restriction.ifPresent(r -> params.put((Object)"restriction", r));
                params.put((Object)"project", (Object)project).put((Object)"readOnly", (Object)readOnly).put((Object)"repository", (Object)scope.getRepository());
                return null;
            }
        });
    }

    private Page<AccessToken> getAccessTokens(ApplicationUser user, Scope scope) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.accessTokenSettingsService.getMaxTokensPerUser());
        if (scope != null) {
            return this.scopeAccessTokenService.search(new AccessTokenSearchRequest.Builder<Scope>(scope).build(), pageRequest);
        }
        return this.userAccessTokenService.search(new AccessTokenSearchRequest.Builder<ApplicationUser>(user).build(), pageRequest);
    }

    @Nullable
    private Scope getScope(List<String> pathParts) {
        if (pathParts.size() == 3 && PROJECTS.equals(pathParts.get(0))) {
            Project project = this.projectService.getByKey(pathParts.get(1));
            return project == null ? null : Scopes.project((Project)project);
        }
        if (pathParts.size() == 5 && PROJECTS.equals(pathParts.get(0)) && REPOS.equals(pathParts.get(2))) {
            Repository repository = this.repositoryService.getBySlug(pathParts.get(1), pathParts.get(3));
            return repository == null ? null : Scopes.repository((Repository)repository);
        }
        return null;
    }

    @Nullable
    private ApplicationUser getUser(List<String> pathParts) {
        if (pathParts.size() == 3 && USERS.equals(pathParts.get(0))) {
            return this.userService.getUserBySlug(pathParts.get(1));
        }
        return null;
    }

    private void render(ServletResponse resp, String templateName, Map<String, Object> data) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, templateName, data);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }
}

