/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.internal.accesstokens.AbstractAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.HashedAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.SimpleAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleHashedAccessToken
extends AbstractAccessToken
implements HashedAccessToken {
    private final String hashedToken;

    private SimpleHashedAccessToken(Builder builder) {
        super(builder);
        this.hashedToken = builder.hashedToken;
    }

    @Nonnull
    public static Builder builder(@Nonnull AoAccessToken accessToken, @Nonnull ApplicationUser user) {
        return new Builder(accessToken, user);
    }

    @Nonnull
    public static Builder builder(@Nonnull String tokenId, @Nonnull String hashedToken) {
        return new Builder(tokenId, hashedToken);
    }

    @Override
    @Nonnull
    public String getHashedToken() {
        return this.hashedToken;
    }

    @Override
    @Nonnull
    public AccessToken toAccessToken() {
        return SimpleAccessToken.builder(this).build();
    }

    public static class Builder
    extends AbstractAccessToken.AbstractBuilder<Builder> {
        private final String hashedToken;

        public Builder(@Nonnull AoAccessToken aoAccessToken, @Nonnull ApplicationUser user, @Nullable Integer effectiveExpiryDays) {
            super(aoAccessToken, user, effectiveExpiryDays);
            this.hashedToken = aoAccessToken.getHashedToken();
        }

        public Builder(@Nonnull AoAccessToken aoAccessToken, @Nonnull ApplicationUser user) {
            this(aoAccessToken, user, null);
        }

        public Builder(@Nonnull AccessToken accessToken, @Nonnull String hashedToken) {
            super(accessToken);
            this.hashedToken = Objects.requireNonNull(hashedToken);
        }

        public Builder(@Nonnull String tokenId, @Nonnull String hashedToken) {
            super(tokenId);
            this.hashedToken = Objects.requireNonNull(hashedToken, "hashedToken");
        }

        @Nonnull
        public HashedAccessToken build() {
            return new SimpleHashedAccessToken(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

