/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens;

import com.atlassian.bitbucket.internal.accesstokens.AbstractAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.RawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.SimpleAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleRawAccessToken
extends AbstractAccessToken
implements RawAccessToken {
    private final String rawToken;

    private SimpleRawAccessToken(Builder builder) {
        super(builder);
        this.rawToken = builder.rawToken;
    }

    @Nonnull
    public static Builder builder(String tokenId, String rawToken) {
        return new Builder(tokenId, rawToken);
    }

    @Nonnull
    public static Builder builder(AoAccessToken aoAccessToken, ApplicationUser user, String rawToken) {
        return new Builder(aoAccessToken, user, rawToken);
    }

    @Override
    @Nonnull
    public String getRawToken() {
        return this.rawToken;
    }

    @Override
    @Nonnull
    public AccessToken toAccessToken() {
        return SimpleAccessToken.builder(this).build();
    }

    public static class Builder
    extends AbstractAccessToken.AbstractBuilder<Builder> {
        private final String rawToken;

        public Builder(String tokenId, String rawToken) {
            super(tokenId);
            this.rawToken = Objects.requireNonNull(rawToken, "rawToken");
        }

        public Builder(AoAccessToken aoAccessToken, ApplicationUser user, String rawToken) {
            this(aoAccessToken, user, null, rawToken);
        }

        public Builder(@Nonnull AoAccessToken aoAccessToken, @Nonnull ApplicationUser user, @Nullable Integer effectiveExpiryDays, @Nonnull String rawToken) {
            super(aoAccessToken, user, effectiveExpiryDays);
            this.rawToken = Objects.requireNonNull(rawToken, "rawToken");
        }

        @Nonnull
        public RawAccessToken build() {
            return new SimpleRawAccessToken(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

