/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.analytics;

import com.atlassian.bitbucket.internal.accesstokens.DateProvider;
import com.atlassian.bitbucket.internal.accesstokens.dao.AccessTokenDao;
import com.atlassian.bitbucket.internal.accesstokens.event.AccessTokenSummaryEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="accessTokenAnalyticsJob")
public class AccessTokenAnalyticsJob
implements LifecycleAware {
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)AccessTokenAnalyticsJob.class.getName());
    static final JobId JOB_ID = JobId.of((String)AccessTokenAnalyticsJob.class.getSimpleName());
    private static final Duration INTERVAL = Duration.ofDays(1L);
    private static final Logger log = LoggerFactory.getLogger(AccessTokenAnalyticsJob.class);
    private final AccessTokenDao accessTokenDao;
    private final DateProvider dateProvider;
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public AccessTokenAnalyticsJob(AccessTokenDao accessTokenDao, DateProvider dateProvider, EventPublisher eventPublisher, SchedulerService schedulerService, TransactionTemplate transactionTemplate) {
        this.accessTokenDao = accessTokenDao;
        this.dateProvider = dateProvider;
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
        this.transactionTemplate = transactionTemplate;
    }

    public void onStart() {
        AccessTokenAnalyticsJobRunner jobRunner = new AccessTokenAnalyticsJobRunner();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)INTERVAL.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(INTERVAL).toInstant()))));
        }
        catch (SchedulerServiceException e) {
            log.warn("Failed to schedule " + String.valueOf(JOB_RUNNER_KEY), (Throwable)e);
        }
    }

    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    class AccessTokenAnalyticsJobRunner
    implements JobRunner {
        AccessTokenAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            AccessTokenSummaryEvent event = (AccessTokenSummaryEvent)((Object)AccessTokenAnalyticsJob.this.transactionTemplate.execute(() -> {
                int total = AccessTokenAnalyticsJob.this.accessTokenDao.countAll();
                int authenticatedRecently = AccessTokenAnalyticsJob.this.accessTokenDao.countByAuthenticatedSince(Date.from(AccessTokenAnalyticsJob.this.dateProvider.getZonedDateTime().minus(INTERVAL).toInstant()));
                return new AccessTokenSummaryEvent(this, total, authenticatedRecently, INTERVAL);
            }));
            if (event.getAuthenticatedRecently() > 0) {
                AccessTokenAnalyticsJob.this.eventPublisher.publish((Object)event);
            }
            return JobRunnerResponse.success();
        }
    }
}

