/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.auth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.internal.accesstokens.AuthenticateAccessTokenRequest;
import com.atlassian.bitbucket.internal.accesstokens.auth.AccessTokenAuthenticationService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;

public class AccessTokenAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final String PROJECT_REPO_TOKEN_USERNAME = "x-token-auth";
    private static final String URL_REST = "/rest/";
    private static final String URL_SCM = "/scm/";
    private final AccessTokenAuthenticationService accessTokenService;
    private final RequestManager requestManager;
    private final UserService userService;

    public AccessTokenAuthenticationHandler(AccessTokenAuthenticationService accessTokenService, RequestManager requestManager, UserService userService) {
        this.accessTokenService = accessTokenService;
        this.requestManager = requestManager;
        this.userService = userService;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext context) {
        HttpServletRequest request = context.getRequest();
        if (this.shouldAuthenticate(request)) {
            if ("basic".equals(context.getMethod())) {
                return this.authenticateBasic(context);
            }
            if ("token".equals(context.getMethod())) {
                return this.authenticateToken(context);
            }
        }
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private AuthenticationResult authenticate(AuthenticateAccessTokenRequest request) {
        return this.accessTokenService.authenticate(request).map(accessToken -> {
            RequestContext requestContext = this.requestManager.getRequestContext();
            if (requestContext != null) {
                requestContext.addLabel("access-token:id:" + accessToken.getId());
            }
            return new AuthenticationResult.Builder(accessToken.getUser()).property("bbs.security.token.id", (Serializable)((Object)accessToken.getId())).build();
        }).orElse(null);
    }

    private AuthenticationResult authenticateBasic(HttpAuthenticationContext context) {
        ApplicationUser user;
        AuthenticationResult tokenAuth;
        String password;
        String username = context.getUsername();
        String string = password = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        if (PROJECT_REPO_TOKEN_USERNAME.equalsIgnoreCase(username) && (tokenAuth = this.authenticateToken(context)) != null && tokenAuth.getUser().getType() == UserType.SERVICE) {
            return tokenAuth;
        }
        if (username != null && password != null && (user = this.userService.getUserByName(username)) != null) {
            AuthenticateAccessTokenRequest request = new AuthenticateAccessTokenRequest.Builder(password).user(user).build();
            return this.authenticate(request);
        }
        return null;
    }

    private AuthenticationResult authenticateToken(HttpAuthenticationContext context) {
        String bearerToken;
        String string = bearerToken = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        if (bearerToken != null) {
            AuthenticateAccessTokenRequest request = new AuthenticateAccessTokenRequest.Builder(bearerToken).build();
            return this.authenticate(request);
        }
        return null;
    }

    private boolean isPassedThrough(HttpServletRequest request) {
        try {
            request.getRequestURL();
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
        return false;
    }

    private boolean shouldAuthenticate(HttpServletRequest request) {
        int contextPathLength;
        String requestURI = request.getRequestURI();
        return requestURI.substring(contextPathLength = request.getContextPath().length()).startsWith(URL_REST) || requestURI.substring(contextPathLength).startsWith(URL_SCM) || this.isPassedThrough(request);
    }
}

