/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.auth;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.InternalAccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.auth.TokenPermissionVoter;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class AccessTokenPermissionVoterProvider
implements PermissionVoterProvider {
    private final InternalAccessTokenService internalAccessTokenService;

    public AccessTokenPermissionVoterProvider(InternalAccessTokenService internalAccessTokenService) {
        this.internalAccessTokenService = internalAccessTokenService;
    }

    public PermissionVoter create(@Nonnull Authentication authentication) {
        Serializable tokenId = (Serializable)authentication.getProperties().get("bbs.security.token.id");
        if (!(tokenId instanceof String)) {
            return null;
        }
        Optional<AccessToken> accessToken = this.internalAccessTokenService.getById((String)((Object)tokenId));
        HashSet<Permission> permissions = new HashSet<Permission>(accessToken.map(AccessToken::getPermissions).orElse(Collections.emptySet()));
        if (permissions.isEmpty()) {
            return null;
        }
        permissions.addAll(permissions.stream().flatMap(permission -> permission.getInheritedPermissions().stream()).collect(Collectors.toSet()));
        permissions.add(Permission.LICENSED_USER);
        return new TokenPermissionVoter(permissions);
    }
}

