/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.auth;

import com.atlassian.bitbucket.auth.ExpiredPasswordAuthenticationException;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenExpiryHelper;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenGenerator;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.AuthenticateAccessTokenRequest;
import com.atlassian.bitbucket.internal.accesstokens.DateProvider;
import com.atlassian.bitbucket.internal.accesstokens.SimpleAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.auth.AccessTokenAuthenticationService;
import com.atlassian.bitbucket.internal.accesstokens.dao.AccessTokenDao;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAccessTokenAuthenticationService
implements AccessTokenAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessTokenAuthenticationService.class);
    private static final String PROP_LAST_AUTHENTICATED_INTERVAL = "plugin.bitbucket-access-tokens.last.authenticated.interval";
    private final AccessTokenDao accessTokenDao;
    private final AccessTokenGenerator accessTokenGenerator;
    private final AccessTokenSettingsService accessTokenSettingsService;
    private final DateProvider dateProvider;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final Gate<String> lastAuthenticatedGate;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    DefaultAccessTokenAuthenticationService(AccessTokenDao accessTokenDao, AccessTokenGenerator accessTokenGenerator, AccessTokenSettingsService accessTokenSettingsService, ApplicationPropertiesService applicationPropertiesService, DateProvider dateProvider, FeatureManager featureManager, I18nService i18nService, TransactionTemplate transactionTemplate, UserService userService) {
        this.accessTokenDao = accessTokenDao;
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenSettingsService = accessTokenSettingsService;
        this.dateProvider = dateProvider;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
        int lastAuthenticatedInterval = applicationPropertiesService.getPluginProperty(PROP_LAST_AUTHENTICATED_INTERVAL, 60);
        this.lastAuthenticatedGate = new Gate((long)Math.max(5, lastAuthenticatedInterval), TimeUnit.SECONDS);
    }

    @Override
    @Nonnull
    public Optional<AccessToken> authenticate(@Nonnull AuthenticateAccessTokenRequest request) {
        Objects.requireNonNull(request, "request");
        String rawToken = this.accessTokenGenerator.getToken(request);
        if (!this.accessTokenGenerator.isValidToken(rawToken)) {
            return Optional.empty();
        }
        String tokenId = this.accessTokenGenerator.getId(rawToken);
        return (Optional)this.transactionTemplate.execute(() -> this.accessTokenDao.getById(tokenId).map(aoAccessToken -> {
            if (!this.accessTokenGenerator.authenticateToken(rawToken, aoAccessToken.getHashedToken())) {
                return null;
            }
            Optional<ApplicationUser> requestUser = request.getUser();
            if (requestUser.isPresent() && requestUser.get().getId() != aoAccessToken.getUserId()) {
                log.warn("The user provided on the request ({}) does not match the user associated with token {} ({})", new Object[]{requestUser.get(), tokenId, aoAccessToken.getUserId()});
                return null;
            }
            Integer maxExpiryDays = this.accessTokenSettingsService.getMaxExpiry().orElse(null);
            if (this.hasExpired(aoAccessToken.getCreatedDate(), aoAccessToken.getExpiryDays(), maxExpiryDays)) {
                throw new ExpiredPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.expired", new Object[0]));
            }
            ApplicationUser user = requestUser.orElseGet(() -> {
                ApplicationUser tokenUser = this.userService.getUserById(aoAccessToken.getUserId());
                if (tokenUser == null) {
                    throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.nosuchuser", new Object[]{aoAccessToken.getUserId()}), "id:" + aoAccessToken.getUserId());
                }
                return tokenUser;
            });
            if (user.getType() == UserType.SERVICE) {
                this.featureManager.requireEnabled((Feature)StandardFeature.PROJECT_REPO_ACCESS_TOKENS);
            }
            if (!this.userService.isUserActive(user)) {
                log.info("User \"{}\" attempted to authenticate via a personal access token, but is no longer active in the underlying user directory. The request has been blocked.", (Object)user.getName());
                throw new InactiveUserAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.access.tokens.error.inactive", new Object[0]));
            }
            this.lastAuthenticatedGate.callIfNotRecentlyRun((Object)aoAccessToken.getID(), () -> this.accessTokenDao.updateLastAuthenticated((AoAccessToken)aoAccessToken, this.dateProvider.getDate()));
            return new SimpleAccessToken.Builder((AoAccessToken)aoAccessToken, user, AccessTokenExpiryHelper.getEffectiveExpiryDays(aoAccessToken.getExpiryDays(), maxExpiryDays)).build();
        }));
    }

    private boolean hasExpired(Date createdDate, Integer tokenExpiryDays, Integer maxExpiryDays) {
        Integer effectiveExpiryDays = AccessTokenExpiryHelper.getEffectiveExpiryDays(tokenExpiryDays, maxExpiryDays);
        return effectiveExpiryDays != null && DateUtils.addDays((Date)createdDate, (int)effectiveExpiryDays).before(this.dateProvider.getDate());
    }
}

