/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.accesstokens.HashedAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AccessTokenDao;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.dao.AoAccessTokenPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.ActiveObjectsException;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoAccessTokenDao
extends AbstractAoDao
implements AccessTokenDao {
    private static final Logger log = LoggerFactory.getLogger(AoAccessTokenDao.class);

    @Autowired
    public AoAccessTokenDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int countAll() {
        return this.ao.count(AoAccessToken.class, Query.select());
    }

    @Override
    @Nonnull
    public int countByAuthenticatedSince(@Nonnull Date since) {
        return this.ao.count(AoAccessToken.class, Query.select().where("LAST_AUTHENTICATED > ?", new Object[]{since}));
    }

    @Override
    public int countForUser(@Nonnull ApplicationUser user) {
        return this.ao.count(AoAccessToken.class, Query.select().where("USER_ID = ?", new Object[]{user.getId()}));
    }

    @Override
    @Nonnull
    public AoAccessToken create(@Nonnull HashedAccessToken hashedAccessToken, @Nullable Integer expiryDays) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"TOKEN_ID", (Object)hashedAccessToken.getId()).put((Object)"HASHED_TOKEN", (Object)hashedAccessToken.getHashedToken()).put((Object)"CREATED_DATE", (Object)hashedAccessToken.getCreatedDate()).put((Object)"NAME", (Object)hashedAccessToken.getName()).put((Object)"USER_ID", (Object)hashedAccessToken.getUser().getId());
        if (expiryDays != null) {
            builder.put((Object)"EXPIRY_DAYS", (Object)expiryDays);
        }
        AoAccessToken createdAccessToken = (AoAccessToken)this.ao.create(AoAccessToken.class, (Map)builder.build());
        hashedAccessToken.getPermissions().forEach(permission -> this.createPermission(createdAccessToken, (Permission)permission));
        return (AoAccessToken)this.ao.get(AoAccessToken.class, (Object)createdAccessToken.getID());
    }

    @Override
    public void delete(@Nonnull AoAccessToken aoAccessToken) {
        Arrays.stream(aoAccessToken.getAccessTokenPermissions()).forEach(xva$0 -> this.ao.delete(new RawEntity[]{xva$0}));
        this.ao.delete(new RawEntity[]{aoAccessToken});
    }

    @Override
    @Nonnull
    public Page<AoAccessToken> findAll(@Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoAccessToken.class, Query.select().order("TOKEN_ID"), pageRequest);
    }

    @Override
    @Nonnull
    public Optional<AoAccessToken> getById(@Nonnull String tokenId) {
        try {
            AoAccessToken aoAccessToken = (AoAccessToken)this.ao.get(AoAccessToken.class, (Object)tokenId);
            return Optional.ofNullable(aoAccessToken);
        }
        catch (ActiveObjectsException e) {
            log.debug("Failed to retrieve token", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    @Nonnull
    public Page<AoAccessToken> searchByUser(@Nonnull ApplicationUser user, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoAccessToken.class, Query.select().where("USER_ID = ?", new Object[]{user.getId()}).order("CREATED_DATE DESC"), pageRequest);
    }

    @Override
    @Nonnull
    public AoAccessToken update(@Nonnull AoAccessToken aoAccessToken, @Nullable String name, @Nonnull Set<Permission> permissions) {
        if (name != null) {
            aoAccessToken.setName(name);
        }
        if (!permissions.isEmpty()) {
            Arrays.stream(aoAccessToken.getAccessTokenPermissions()).filter(aoAccessTokenPermission -> !permissions.contains(Permission.fromId((int)aoAccessTokenPermission.getPermissionId()))).forEach(xva$0 -> this.ao.delete(new RawEntity[]{xva$0}));
            Set existingPermissions = Arrays.stream(aoAccessToken.getAccessTokenPermissions()).map(aoAccessTokenPermission -> Permission.fromId((int)aoAccessTokenPermission.getPermissionId())).collect(Collectors.toSet());
            Sets.difference(permissions, existingPermissions).forEach(permission -> this.createPermission(aoAccessToken, (Permission)permission));
        }
        aoAccessToken.save();
        return (AoAccessToken)this.ao.get(AoAccessToken.class, (Object)aoAccessToken.getID());
    }

    @Override
    public void updateLastAuthenticated(@Nonnull AoAccessToken aoAccessToken, @Nonnull Date authenticatedDate) {
        aoAccessToken.setLastAuthenticated(authenticatedDate);
        aoAccessToken.save();
    }

    private AoAccessTokenPermission createPermission(AoAccessToken accessToken, Permission permission) {
        return (AoAccessTokenPermission)this.ao.create(AoAccessTokenPermission.class, (Map)ImmutableMap.builder().put((Object)"FK_ACCESS_TOKEN_ID", (Object)accessToken.getID()).put((Object)"PERMISSION", (Object)permission.getId()).build());
    }
}

